from load.projects.cloud.loadtesting.server.obfuscator.base import Obfuscator
# from yandex.cloud.priv.loadtesting.agent.v1 import monitoring_service_pb2
from load.projects.cloud.tank_client.proto import monitoring_service_pb2


class CreateMonitoringRequest(Obfuscator):
    target_class = monitoring_service_pb2.CreateMonitoringRequest

    def data(self) -> dict:
        request: monitoring_service_pb2.CreateMonitoringRequest = self.original

        return {
            'compute_instance_id': request.compute_instance_id,
        }


class CreateMonitoringResponse(Obfuscator):
    target_class = monitoring_service_pb2.CreateMonitoringResponse

    def data(self) -> dict:
        response: monitoring_service_pb2.CreateMonitoringResponse = self.original

        return {
            'code': response.code,
            'metric_trail_id': response.monitoring_id
        }
