from load.projects.cloud.loadtesting.server.obfuscator.base import Obfuscator
from yandex.cloud.priv.loadtesting.v1 import resource_preset_pb2 as resource
from yandex.cloud.priv.loadtesting.v1 import resource_preset_service_pb2 as resource_service


class GetResourcePresetRequest(Obfuscator):
    target_class = resource_service.GetResourcePresetRequest

    def data(self) -> dict:
        request: resource_service.GetResourcePresetRequest = self.original

        return {
            'preset_id': request.preset_id,
        }


def _preset_data(preset: resource.ResourcePreset):
    return {
        'preset_id': preset.preset_id,
        'name': preset.name,
        'cores': preset.cores,
        'memory': preset.memory,
        'disk_size': preset.disk_size,
    }


class ResourcePreset(Obfuscator):
    target_class = resource.ResourcePreset

    def data(self) -> dict:
        response: resource.ResourcePreset = self.original

        return _preset_data(response)


class ListResourcePresetsRequest(Obfuscator):
    target_class = resource_service.ListResourcePresetsRequest

    def data(self) -> dict:
        request: resource_service.ListResourcePresetsRequest = self.original

        return {
            'page_size': request.page_size,
            'page_token': request.page_token,
            'filter': request.filter,
        }


class ListResourcePresetsResponse(Obfuscator):
    target_class = resource_service.ListResourcePresetsResponse

    def data(self) -> dict:
        response: resource_service.ListResourcePresetsResponse = self.original

        return {
            'next_page_token': response.next_page_token,
            'resource_presets': [
                _preset_data(p)
                for p in response.resource_presets
            ],
        }
