from google.protobuf.json_format import MessageToDict

from load.projects.cloud.loadtesting.server.obfuscator.base import Obfuscator
from yandex.cloud.priv.loadtesting.v1 import tank_instance_pb2
from yandex.cloud.priv.loadtesting.v1 import tank_instance_service_pb2


class GetTankInstanceRequest(Obfuscator):
    target_class = tank_instance_service_pb2.GetTankInstanceRequest

    def data(self) -> dict:
        request: tank_instance_service_pb2.GetTankInstanceRequest = self.original

        return {
            'id': request.id,
        }


def _tank_instance_data(tank_instance: tank_instance_pb2.TankInstance):
    version: tank_instance_pb2.AgentVersion = tank_instance.agent_version
    return {
        'id': tank_instance.id,
        'folder_id': tank_instance.folder_id,
        'created_at': tank_instance.created_at.ToJsonString(),
        'compute_instance_updated_at': tank_instance.compute_instance_updated_at.ToJsonString(),
        'name': tank_instance.name,
        'labels': dict(tank_instance.labels),
        'service_account_id': tank_instance.service_account_id,
        'preset_id': tank_instance.preset_id,
        'tank_version': tank_instance.tank_version,
        'status': tank_instance_pb2.TankInstance.Status.Name(tank_instance.status),
        'errors_number': len(tank_instance.errors),
        'current_job': tank_instance.current_job,
        'compute_instance_id': tank_instance.compute_instance_id,
        'agent_version': {
            'id': version.id,
            'revision': version.revision,
            'status': tank_instance_pb2.AgentVersion.VersionStatus.Name(version.status),
        }
    }


class GetTankInstanceResponse(Obfuscator):
    target_class = tank_instance_service_pb2.GetTankInstanceResponse

    def data(self) -> dict:
        response: tank_instance_service_pb2.GetTankInstanceResponse = self.original

        return {
            'tank_instance': _tank_instance_data(response.tank_instance),
        }


class ListTankInstancesRequest(Obfuscator):
    target_class = tank_instance_service_pb2.ListTankInstancesRequest

    def data(self) -> dict:
        request: tank_instance_service_pb2.ListTankInstancesRequest = self.original

        return {
            'folder_id': request.folder_id,
            'page_size': request.page_size,
            'page_token': request.page_token,
            'filter': request.filter,
        }


class TankInstancesList(Obfuscator):
    target_class = tank_instance_service_pb2.TankInstancesList

    def data(self) -> dict:
        responce: tank_instance_service_pb2.TankInstancesList = self.original

        return {
            'folder_id': responce.folder_id,
            'next_page_token': responce.next_page_token,
            'tank_instances': [
                _tank_instance_data(t)
                for t in responce.tank_instances
            ],
        }


class CreateTankInstanceRequest(Obfuscator):
    target_class = tank_instance_service_pb2.CreateTankInstanceRequest

    def data(self) -> dict:
        request: tank_instance_service_pb2.CreateTankInstanceRequest = self.original

        return {
            'folder_id': request.folder_id,
            'name': request.name,
            'description': request.description,
            'labels': dict(request.labels),
            'preset_id': request.preset_id,
            'service_account_id': request.service_account_id,
            'tank_folder_id': request.tank_folder_id,
            'zone_id': request.zone_id,
            'network_interfaces': [
                MessageToDict(i)
                for i in request.network_interface_specs
            ],
            'metadata': dict(request.metadata),
        }


class DeleteTankInstanceRequest(Obfuscator):
    target_class = tank_instance_service_pb2.DeleteTankInstanceRequest

    def data(self) -> dict:
        request: tank_instance_service_pb2.DeleteTankInstanceRequest = self.original

        return {
            'id': request.id
        }


class RestartTankInstanceRequest(Obfuscator):
    target_class = tank_instance_service_pb2.RestartTankInstanceRequest

    def data(self) -> dict:
        request: tank_instance_service_pb2.RestartTankInstanceRequest = self.original

        return {
            'id': request.id
        }


class StopTankInstanceRequest(Obfuscator):
    target_class = tank_instance_service_pb2.StopTankInstanceRequest

    def data(self) -> dict:
        request: tank_instance_service_pb2.StopTankInstanceRequest = self.original

        return {
            'id': request.id
        }


class StartTankInstanceRequest(Obfuscator):
    target_class = tank_instance_service_pb2.StartTankInstanceRequest

    def data(self) -> dict:
        request: tank_instance_service_pb2.StartTankInstanceRequest = self.original

        return {
            'id': request.id
        }
