# import yandex.cloud.priv.loadtesting.agent.v1.monitoring_service_pb2 as monitoring_messages
import load.projects.cloud.tank_client.proto.monitoring_service_pb2 as messages
from load.projects.cloud.loadtesting.db.connection import get_clickhouse_client
from load.projects.cloud.loadtesting.db.tables import JobTable


def push_to_clickhouse(create_trail: messages.CreateMonitoringRequest, job: JobTable):
    values = []
    if not create_trail.data:
        return
    for metric in create_trail.data:
        values.append(','.join(map(str, [
            f"toDateTime({create_trail.timestamp})",
            job.n,
            f"'{create_trail.instance_host}'",
            f"'{metric.metric_type}'",
            f"'{metric.metric_name}'",
            float(metric.metric_value),
        ])))
    with get_clickhouse_client() as client:
        sql = 'INSERT INTO loadtesting.monitoring_verbose_data_buffer VALUES ({mon_data})'.format(
            mon_data='),('.join(values)
        )
        client.execute(sql)
