CREATE DATABASE IF NOT EXISTS tests;

USE tests;

CREATE TABLE if not exists tests_data (
-- metadata
    id String,
    n UInt64,
    folder_id String,
    user_id Nullable(String),
    name Nullable(String),
    description Nullable(String),
    labels Nullable(String),  -- FIXME
    status String,
    status_updated_at Nullable(DateTime),
    created_at DateTime,
    started_at DateTime,
    finished_at DateTime,
    updated_at Nullable(DateTime),
    target_address Nullable(String),
    target_port Nullable(UInt64),
    version Nullable(String),
    generator Nullable(String),
    favorite Nullable(UInt8),
    tank_id Nullable(String),
    errors Nullable(String),  -- FIXME
    internal_tank_error Nullable(String),
    timestamp DateTime,
    "case" String,
    reqps Nullable(UInt64),
    resps Nullable(UInt64),
    instances Nullable(UInt64),

    -- response codes and times
    rt_bin Nullable(UInt64),
    rt_count Nullable(UInt64),
    net_codes Nullable(UInt64),
    net_count Nullable(UInt64),
    proto_codes Nullable(UInt64),
    proto_count Nullable(UInt64),
    q50 Nullable(Float64),
    q75 Nullable(Float64),
    q80 Nullable(Float64),
    q85 Nullable(Float64),
    q90 Nullable(Float64),
    q95 Nullable(Float64),
    q98 Nullable(Float64),
    q99 Nullable(Float64),
    q100 Nullable(Float64),

    -- average connection times
    connect_time Nullable(Float64),
    send_time Nullable(Float64),
    latency Nullable(Float64),
    receive_time Nullable(Float64),

    --data volume
    igress Nullable(UInt64),
    egress Nullable(UInt64),
    self_load Nullable(UInt64)

)
    ENGINE = MergeTree
    PARTITION BY toYYYYMM(timestamp)
    ORDER BY (id, n, folder_id, timestamp)
;


CREATE TABLE if not exists monitoring_data(
    job_n UInt64,
    job_id UUID,
    timestamp DateTime,
    metric_name String,
    metric_subname String,
    host_name String,
    host_alias String,
    value UInt64
) ENGINE = MergeTree ORDER BY job_n;
