#!/bin/bash

set -x -euo pipefail
DAEMON_NAME=cloud-yandex-tank

compile_proto() {
    pip3 install grpcio grpcio-tools
    SITE=$(python3 -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")
    python3 -m grpc_tools.protoc \
        --python_out=$SITE  \
        --grpc_python_out=$SITE \
        -I /tmp/bootstrap/yandex-tank/yandextank/plugins/DataUploader/proto \
        /tmp/bootstrap/yandex-tank/yandextank/plugins/DataUploader/proto/*.proto
    python3 -m grpc_tools.protoc \
        --python_out=$SITE  \
        --grpc_python_out=$SITE \
        -I /tmp/bootstrap/yandex-tank/yandextank/plugins/CloudUploader/proto \
        /tmp/bootstrap/yandex-tank/yandextank/plugins/CloudUploader/proto/*.proto
}

main() {
    compile_proto
}

main
