from __future__ import print_function
import logging

import grpc

from healthcheck_pb2_grpc import HealthCheckStub
from healthcheck_pb2 import HealthRequest



def run():
    # NOTE(gRPC Python Team): .close() is possible on a channel and should be
    # used in circumstances in which the with statement does not fit the needs
    # of the code.
    with grpc.insecure_channel('localhost:50051') as channel:
        stub = HealthCheckStub(channel)
        response = stub.CheckHealth(HealthRequest(health_check_group_id='oops'))
    print('CheckHealth client received: ' + str(response.status))

if __name__ == '__main__':
    logging.basicConfig()
    run()
