from healthcheck_pb2_grpc import HealthCheckServicer, add_HealthCheckServicer_to_server
from healthcheck_pb2 import HealthRequest, HealthCheckResult

from concurrent import futures
import logging

import grpc


def get_health_status(group_id):
    return HealthCheckResult(
        health_check_group_id=group_id,
        name='firestarter',
        subnet_id='some subnet',
        address='192.168.1.1',
        status=0,
    )


class HealthChecker(HealthCheckServicer):
    def CheckHealth(self, request, context):
        return get_health_status(request.health_check_group_id)

    def WatchHealth(self, request, context):
        counter = 0
        while counter < 20:
            counter += 1
            yield get_health_status(request)


def serve():
    server = grpc.server(futures.ThreadPoolExecutor(max_workers=5))
    add_HealthCheckServicer_to_server(HealthChecker(), server)
    server.add_insecure_port('[::]:50051')
    server.start()
    server.wait_for_termination()


if __name__ == '__main__':
    logging.basicConfig()
    serve()
