from flask import Flask

try:
    from .routes import bp
    from .config import Config
except ImportError:
    from routes import bp
    from config import Config


def create_app(config=Config):

    app = Flask(__name__)
    app.config.from_object(config)

    app.register_blueprint(bp)

    return app


if __name__ == '__main__':
    app = create_app()
    app.run(debug=True)
