class InternalStatus:
    NEW = 'new'
    VALIDATED = 'validated'
    FAILED_TO_START = 'failed to start'
    TANK_FOUND = 'tank found'
    INITIATED = 'initiated'
    PREPARING = 'preparing'
    STARTED = 'test started'
    RUNNING = 'running'
    POST_PROCESS = 'post_process'
    FINISHING = 'finishing'
    FINISHED = 'finished'
    FAILED = 'failed'


class ExternalStatus:
    PENDING = 'pending'
    FAILURE = 'failure'
    IN_PROGRESS = 'in progress'
    SUCCESS = 'success'


STATUS_MAP = {
    InternalStatus.NEW: ExternalStatus.PENDING,
    InternalStatus.VALIDATED: ExternalStatus.PENDING,
    InternalStatus.FAILED_TO_START: ExternalStatus.FAILURE,
    InternalStatus.FAILED: ExternalStatus.FAILURE,
    InternalStatus.TANK_FOUND: ExternalStatus.PENDING,
    InternalStatus.INITIATED: ExternalStatus.PENDING,
    InternalStatus.PREPARING: ExternalStatus.PENDING,
    InternalStatus.RUNNING: ExternalStatus.IN_PROGRESS,
    InternalStatus.FINISHING: ExternalStatus.IN_PROGRESS,
    InternalStatus.POST_PROCESS: ExternalStatus.IN_PROGRESS,
    InternalStatus.FINISHED: ExternalStatus.SUCCESS
}
