# -*- coding: utf-8 -*-
from flask import Flask
from flask_sqlalchemy import SQLAlchemy
from lp_queue.config import Config
import logging

app = Flask(__name__, static_url_path='/static')
app.config.from_object(Config)
app.config['SQLALCHEMY_TRACK_MODIFICATIONS'] = False

handler = logging.FileHandler(app.config['ERROR_LOGTO'])  # errors logged to this file
handler.setLevel(logging.INFO)  # only log errors and above
app.logger.addHandler(handler)
app.logger.info('Logging initiated')

db = SQLAlchemy(app)

import lp_queue.views
# ===================================================================== stupid flask
