import os
basedir = os.path.abspath(os.path.dirname(__file__))

ENV_TYPE = os.environ.get('ENV_TYPE', 'development')


class Config:
    DEBUG = ENV_TYPE in ('testing', 'development')
    TESTING = ENV_TYPE in ('testing', 'development')
    CSRF_ENABLED = True
    SECRET_KEY = os.environ.get('SECRET_KEY', 'this-really-needs-to-be-changed')
    DB_HOST = os.environ.get('DB_HOST')
    DB_USER = 'lunapark'
    DB_PASS = os.environ.get('DB_PASS')
    DB_PORT = '12000'
    DB_NAME = os.environ.get('DB_NAME')
    SQLALCHEMY_DATABASE_URI = f'postgresql+psycopg2://{DB_USER}:{DB_PASS}@{DB_HOST}:{DB_PORT}/{DB_NAME}'
    ERROR_LOGTO = 'flask_error.log'
    CC_URL = os.environ.get('CC_URL')

# class ProductionConfig(Config):
#     SECRET_KEY = os.environ.get('SECRET_KEY')
#     pass
#
#
# class DevelopmentConfig(Config):
#     DEVELOPMENT = True
#     DEBUG = True
#     DB_HOST = 'pgaas-test.mail.yandex.net'
#     DB_USER = 'lunapark'
#     DB_NAME = 'lpqdb_test'
#     DB_PASS = os.environ.get('DB_PASS')
#     # if not DB_PASS:
#     #     with open('/etc/dbpass') as db_pass_file:
#     #         DB_PASS = db_pass_file.read().strip()
#     DB_PORT = '12000'
#     SQLALCHEMY_DATABASE_URI = 'postgresql+psycopg2://{DB_USER}:{DB_PASS}@{DB_HOST}:{DB_PORT}/{DB_NAME}'.format(
#         DB_HOST=DB_HOST,
#         DB_USER=DB_USER,
#         DB_PASS=DB_PASS,
#         DB_PORT=DB_PORT,
#         DB_NAME=DB_NAME,
#     )
#
#
# class TestingConfig(Config):
#     TESTING = True
#     SECRET_KEY = os.environ.get('SECRET_KEY')
#     DB_HOST = 'pgaas-test.mail.yandex.net'
#     DB_USER = 'lunapark'
#     DB_NAME = 'lpqdb_test'
#     DB_PASS = os.environ.get('DB_PASS')
#     DB_PORT = '12000'
#     SQLALCHEMY_DATABASE_URI = 'postgresql+psycopg2://{DB_USER}:{DB_PASS}@{DB_HOST}:{DB_PORT}/{DB_NAME}'.format(
#         DB_HOST=DB_HOST,
#         DB_USER=DB_USER,
#         DB_PASS=DB_PASS,
#         DB_PORT=DB_PORT,
#         DB_NAME=DB_NAME,
#     )
