"""empty message

Revision ID: 08ed0425c9b0
Revises: 139cb0dc4ddf
Create Date: 2018-03-02 14:36:40.048721

"""

# revision identifiers, used by Alembic.
revision = '08ed0425c9b0'
down_revision = '139cb0dc4ddf'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('default_config',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=128), nullable=True),
    sa.Column('content', sa.Text(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('executor',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('type', sa.Text(), nullable=True),
    sa.Column('capabilities', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('lock',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('task', sa.Integer(), nullable=False),
    sa.Column('what', sa.Text(), nullable=True),
    sa.ForeignKeyConstraint(['task'], ['task.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.drop_table('tank')
    op.add_column('task', sa.Column('configinitial', sa.Text(), nullable=True))
    op.drop_column('task', 'job')
    op.drop_column('task', 'config_initial')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('task', sa.Column('config_initial', sa.TEXT(), autoincrement=False, nullable=True))
    op.add_column('task', sa.Column('job', sa.VARCHAR(length=128), autoincrement=False, nullable=True))
    op.drop_column('task', 'configinitial')
    op.create_table('tank',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('tank_name', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('capabilities', postgresql.JSONB(astext_type=sa.Text()), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='tank_pkey')
    )
    op.drop_table('lock')
    op.drop_table('executor')
    op.drop_table('default_config')
    # ### end Alembic commands ###
