"""empty message

Revision ID: f24967f24ead
Revises: 08ed0425c9b0
Create Date: 2018-03-15 15:31:25.785542

"""

# revision identifiers, used by Alembic.
revision = 'f24967f24ead'
down_revision = '08ed0425c9b0'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('default_configs',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=128), nullable=True),
    sa.Column('content', sa.Text(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('demands',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('task', sa.Integer(), nullable=False),
    sa.Column('key', sa.String(length=128), nullable=True),
    sa.Column('value', sa.Text(), nullable=True),
    sa.Column('value_type', sa.String(length=32), nullable=True),
    sa.ForeignKeyConstraint(['task'], ['task.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('locks',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('task', sa.Integer(), nullable=False),
    sa.Column('what', sa.Text(), nullable=True),
    sa.ForeignKeyConstraint(['task'], ['task.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.drop_table('lock')
    op.drop_table('default_config')
    op.drop_table('executor')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('executor',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('type', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('capabilities', postgresql.JSONB(astext_type=sa.Text()), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='executor_pkey')
    )
    op.create_table('default_config',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('name', sa.VARCHAR(length=128), autoincrement=False, nullable=True),
    sa.Column('content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='default_config_pkey')
    )
    op.create_table('lock',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('task', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('what', sa.TEXT(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['task'], ['task.id'], name='lock_task_fkey'),
    sa.PrimaryKeyConstraint('id', name='lock_pkey')
    )
    op.drop_table('locks')
    op.drop_table('demands')
    op.drop_table('default_configs')
    # ### end Alembic commands ###
