import logging
import time


def log_time(func):
    """
    used for debugging
    :param func:
    :return:
    """
    def wrapped(*args, **kwargs):
        start = time.time()
        res = func(*args, **kwargs)
        logging.error('TIMER %s: %s', func.__name__, time.time() - start)
        return res

    return wrapped


class Memoize(object):
    """
    decorator for class property values caching
    """

    def __init__(self, prop):
        self.prop = prop

    def __call__(self, self1, *args, **kwargs):
        try:
            cache = self1.__method_results_cache
        except AttributeError:
            cache = self1.__method_results_cache = {}

        if self.prop not in cache:
            cache[self.prop] = self.prop(self1, *args, **kwargs)
        return cache[self.prop]

    @staticmethod
    def clear(inst):
        try:
            del inst.__method_results_cache
        except AttributeError:
            pass
