#!/bin/bash
set -e
if [[ -z "${ENV_TYPE}" ]]; then
  export DJANGO_SETTINGS_MODULE="volta.settings.dev"
else
  export DJANGO_SETTINGS_MODULE="volta.settings.${ENV_TYPE}"
fi
echo "Applying settings from $DJANGO_SETTINGS_MODULE"
echo "Apply database migrations"
(cd volta && python3 ./manage.py migrate) |& tee migration.log
cron &
envsubst '${VHOST} ${CLICKHOUSE_HOST} ${CLICKHOUSE_PORT} ${CLICKHOUSE_USER} ${CLICKHOUSE_PASS}' < ./nginx.template > /etc/nginx/nginx.conf
nginx -g 'daemon off;' -c /etc/nginx/nginx.conf &
exec unbuffer uwsgi --ini uwsgi.ini "$@" |& tee /var/log/luna-back/uwsgi.log
