# -*- coding: utf-8 -*-
# Generated by Django 1.11.9 on 2019-02-05 22:54
from __future__ import unicode_literals

from django.db import migrations, models
import sys


def copy_duration(apps, schema_editor):
    Job = apps.get_model("common", "Job")
    JobMeta = apps.get_model("common", "JobMeta")
    for i in JobMeta.objects.filter(key__exact='_duration'):
        job = Job.objects.get(pk=i.job.pk)
        try:
            job.duration = int(i.value) if len(i.value)>0 else None
        except Exception as e:
            print("value: {}".format(i.value), file=sys.stderr)
            raise e
        job.save()


class Migration(migrations.Migration):

    dependencies = [
        ('common', '0006_auto_20181012_1055'),
    ]

    operations = [
        migrations.AddField(
            model_name='job',
            name='duration',
            field=models.BigIntegerField(default=None, null=True),
        ),
        migrations.RunPython(copy_duration),
    ]
