# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-04-03 14:04
from __future__ import unicode_literals

import django.contrib.postgres.fields
import sys
from django.db import migrations, models


def copy_type(apps, schema_editor):
    Data = apps.get_model("common", "Data")
    for d in Data.objects.all():
        try:
            d.types = [d.type]
            d.save()
        except Exception as e:
            print("Data {} type {}".format(d.uniq_id, d.type), file=sys.stderr)
            raise e


class Migration(migrations.Migration):

    dependencies = [
        ('common', '0008_auto_20190211_1756'),
    ]

    operations = [
        migrations.AddField(
            model_name='data',
            name='types',
            field=django.contrib.postgres.fields.ArrayField(base_field=models.CharField(choices=[('metrics', 'metrics'), ('events', 'events'), ('aggregates', 'aggregates'), ('distributions', 'distributions'), ('histograms', 'histograms')], max_length=20), default=list, size=None),
        ),
        migrations.RunPython(copy_type)
    ]
