# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-07-22 20:30
from __future__ import unicode_literals

import django.contrib.postgres.fields
import django.contrib.postgres.fields.hstore
from django.contrib.postgres.operations import HStoreExtension
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('common', '0010_case'),
    ]

    operations = [
        HStoreExtension(),
        migrations.CreateModel(
            name='Function',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=512, unique=True)),
                ('description', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='Regression',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=512, unique=True)),
                ('group_by', models.CharField(default='_job', max_length=256)),
                ('jobs', models.ManyToManyField(to='common.Job')),
            ],
        ),
        migrations.CreateModel(
            name='RegressionSeries',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('filter', django.contrib.postgres.fields.hstore.HStoreField()),
                ('regression', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='common.Regression')),
            ],
        ),
        migrations.CreateModel(
            name='SLA',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lt', models.FloatField(blank=True, null=True)),
                ('le', models.FloatField(blank=True, null=True)),
                ('ge', models.FloatField(blank=True, null=True)),
                ('gt', models.FloatField(blank=True, null=True)),
                ('function', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='common.Function')),
                ('regression_series', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='common.RegressionSeries')),
            ],
        ),
        migrations.CreateModel(
            name='StatStorage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('filter', django.contrib.postgres.fields.hstore.HStoreField()),
                ('args', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=128), default=list, size=None)),
                ('value', models.FloatField()),
                ('function', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='common.Function')),
                ('job', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='common.Job')),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='statstorage',
            unique_together=set([('function', 'job', 'filter', 'args')]),
        ),
    ]
