# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-01-21 15:05
from __future__ import unicode_literals

from django.db import migrations, models
from django.db.models import F, Subquery, OuterRef


def copy_uuids(apps, schema_editor):
    Case = apps.get_model("common", "Case")
    for case in Case.objects.all():
        case.parent_uuid = case.parent_tag.uniq_id
        case.save()


def reverse_copy_uuids(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('common', '0019_sla_name'),
    ]

    operations = [
        migrations.RenameField(
            model_name='case',
            old_name='tag',
            new_name='tag_text',
        ),
        migrations.AddField(
            model_name='case',
            name='parent_uuid',
            field=models.TextField(default=''),
            preserve_default=False,
        ),
        migrations.RunPython(copy_uuids,
                             reverse_code=reverse_copy_uuids),
    ]
