# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-01-21 19:41
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
from django.db.models import OuterRef, Subquery


def fill_data(apps, schema_editor):
    Case = apps.get_model("common", "Case")
    Data = apps.get_model('common', 'Data')
    corresponding_data = Data.objects.filter(uniq_id=OuterRef('parent_uuid')).values_list('id')[:1]
    Case.objects.all().update(data=Subquery(corresponding_data))


class Migration(migrations.Migration):

    dependencies = [
        ('common', '0021_remove_case_parent_tag'),
    ]

    operations = [
        migrations.AddField(
            model_name='case',
            name='data',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='common.Data'),
        ),
        migrations.RunPython(fill_data),
    ]
