from django.http import HttpResponse
from common.models import Job


def favicon(_):
    return HttpResponse('')


def apply_filters(job_filters, meta_filters):
    jobs = Job.objects.all()
    if 'status' in job_filters:
        jobs = jobs.filter(status__in=job_filters['status'])
    if 'id' in job_filters:
        jobs = jobs.filter(id__in=job_filters['id'])
    if 'test_start' in job_filters:
        jobs = jobs.filter(test_start__in=job_filters['test_start'])
    for meta_filter_key in meta_filters.keys():
        jobs = jobs.filter(jobmeta__key=meta_filter_key)
        for f in meta_filters[meta_filter_key]:
            jobs = jobs.filter(jobmeta__value__icontains=f)
    return jobs.distinct()
