"""
Basic Django settings for Luna project
"""
import os


BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
LOG_FILE_PATH = os.environ.get('DJANGO_LOG', '/var/log/luna-back/django.log')
SECRET_KEY = os.environ.get('SECRET_KEY')
ALLOWED_HOSTS = ['localhost', '127.0.0.1']

ARTIFACTS_LIST_REQUEST_TIMEOUT = os.environ.get('ARTIFACTS_LIST_REQUEST_TIMEOUT', 5)
ARTIFACTS_GET_REQUEST_TIMEOUT = os.environ.get('ARTIFACTS_GET_REQUEST_TIMEOUT', 5)

INSTALLED_APPS = [
    'api.apps.ApiConfig',
    'common.apps.ApiConfig',
    'job_page.apps.ApiConfig',
    'job_list.apps.ApiConfig',
    'compare.apps.ApiConfig',
    'regression.apps.ApiConfig',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.postgres',
    'tastypie',
    'django_pgaas'
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'urls'

WSGI_APPLICATION = 'volta.wsgi.application'


file_handler = {
    'level': 'INFO',
    'class': 'logging.handlers.RotatingFileHandler',
    'filename': LOG_FILE_PATH,
    'maxBytes': 100 * 1024 ** 2,  # 100 MB
    'backupCount': 0,
    'formatter': 'specific',
    'encoding': 'utf-8'
    }

# LOGGING_CONFIG = None
LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'verbose': {
            'format': '%(levelname)s %(asctime)s %(module)s %(process)d %(thread)d %(message)s'
        },
        'specific': {
            'format': '%(levelname)s %(asctime)s %(message)s'
        },
    },
    'handlers': {
        'console': {
            'level': 'DEBUG',
            'class': 'logging.StreamHandler',
            'formatter': 'specific',
        }
    },
    'loggers': {
        'django': {
            'handlers': [],
            'propagate': 'True',
        },
        # 'django.server': {
        #     'handlers': ['console'],
        #     'propagate': 'True',
        # },
        # 'django.request': {
        #     'handlers': ['console'],
        #     'propagate': 'True',
        # },
    },
}

CLICKHOUSE_SSL = True

# Internationalization
# https://docs.djangoproject.com/en/2.0/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'Europe/Moscow'

USE_I18N = True

USE_L10N = True

USE_TZ = True

STATIC_URL = '/static/'
