from collections import defaultdict
from vault_client.instances import Production as VaultClient
from vault_client.errors import ClientError
from .base import *

try:
    VAULT = VaultClient(decode_files=True).get_version('sec-01dj5kptvw40nz314dy47v2rpy')['value']
except ClientError:
    # Trendbox do not have access to yav, using Sandbox Vault as workaround
    # All secrets are copied to Sandbox Vault with prefix 'env', LOAD is an owner
    # In case of change, secrets should be manually copied to another storage
    VAULT = defaultdict(lambda: None)

DEBUG = True
ENV_TYPE = 'dev'

SECRET_KEY = os.environ.get('SECRET_KEY') or VAULT['luna_dev_secret_key']

ALLOWED_HOSTS.append('dev-back.luna.yandex-team.ru')

DB_HOST = os.environ.get('DB_HOST') or 'vla-xyjjhgqdhnapj3uv.db.yandex.net'
DB_PASS = os.environ.get('DB_PASS') or VAULT['luna_dev_pgaas_pass']
DB_PORT = os.environ.get('DB_PORT') or '6432'
DB_NAME = os.environ.get('DB_NAME') or 'voltadb_test'
DB_USER = os.environ.get('DB_USER') or 'lunapark'
DB_OPTIONS = {
    'sslmode': 'verify-full',
    'target_session_attrs': 'read-write'
    }

DATABASES = {
    'default': {
        'DISABLE_SERVER_SIDE_CURSORS': True,  # server-side cursors are incompatible with pgbouncer
        'ENGINE': 'django.db.backends.postgresql_psycopg2',  # 'pgaas_db_backend'
        'NAME': DB_NAME,
        'USER': DB_USER,
        'PASSWORD': DB_PASS,
        'HOST': DB_HOST,
        'PORT': DB_PORT,
        'TEST': {
          'NAME': DB_NAME
        },
        'OPTIONS': {
            'sslmode': 'require',
            'target_session_attrs': 'read-write'
        },
        'CONN_MAX_AGE': 49,
    },
    'slave': {
        'DISABLE_SERVER_SIDE_CURSORS': True,
        'ENGINE': 'django.db.backends.postgresql_psycopg2',  # 'pgaas_db_backend'
        'NAME': DB_NAME,
        'USER': DB_USER,
        'PASSWORD': DB_PASS,
        'HOST': DB_HOST,
        'PORT': DB_PORT,
        'TEST_USER': 'root',
        'TEST_CHARSET': 'utf8',
        'TEST_COLLATION': 'utf8_general_ci',
        'TEST': {
            'NAME': DB_NAME,
            'MIRROR': 'default'
        },
        'OPTIONS': {
            'sslmode': 'require',
            'target_session_attrs': 'any'
        },
        'CONN_MAX_AGE': 49,
    },
}
LOGGING['handlers']['file'] = file_handler
LOGGING['loggers']['django']['handlers'] = ['console', 'file']
LOGGING['root'] = {
    'level': 'DEBUG',
    'handlers': ['console', 'file']
}

CLICKHOUSE_HOST = os.environ.get('CLICKHOUSE_HOST') or 'sas-b9etc59rfykwzc5r.db.yandex.net'
CLICKHOUSE_PORT = os.environ.get('CLICKHOUSE_PORT') or '8443'
CLICKHOUSE_PASS = os.environ.get('CLICKHOUSE_PASS') or VAULT['luna_dev_clickhouse_pass']
CLICKHOUSE_USER = os.environ.get('CLICKHOUSE_USER') or 'lunapark'
CLICKHOUSE_NAME = os.environ.get('CLICKHOUSE_NAME') or 'luna_test'
