from django_pgaas import HostManager

from .base import *

DEBUG = False
ENV_TYPE = 'production'
SECRET_KEY = os.environ

ALLOWED_HOSTS.append('back.luna.yandex-team.ru')

MIDDLEWARE.append('django.middleware.csrf.CsrfViewMiddleware')

hosts = [
    ('sas-xx98e3l83sgwykuy.db.yandex.net', 'sas'),
    ('man-j5lnxfdexgg3mx8m.db.yandex.net', 'man'),
    ('vla-7vla7tzx46ryhtyq.db.yandex.net', 'vla'),
]
manager = HostManager(hosts)

DB_HOST = manager.host_string
DB_PORT = os.environ.get('DB_PORT')
DB_NAME = os.environ.get('DB_NAME', 'voltadb')
DB_PASS = os.environ.get('DB_PASS')
DB_USER = os.environ.get('DB_USER')

DATABASES = {
    'default': {
        'DISABLE_SERVER_SIDE_CURSORS': True,  # server-side cursors are incompatible with pgbouncer
        'ENGINE': 'django.db.backends.postgresql_psycopg2',  # 'pgaas_db_backend'
        'NAME': DB_NAME,
        'USER': DB_USER,
        'PASSWORD': DB_PASS,
        'HOST': DB_HOST,
        'PORT': DB_PORT,
        'TEST_USER': 'root',
        'TEST_CHARSET': 'utf8',
        'TEST_COLLATION': 'utf8_general_ci',
        'OPTIONS': {
            'sslmode': 'require',
            'target_session_attrs': 'read-write'
        },
        'CONN_MAX_AGE': 49,
    },
    'slave': {
        'DISABLE_SERVER_SIDE_CURSORS': True,
        'ENGINE': 'django.db.backends.postgresql_psycopg2',  # 'pgaas_db_backend'
        'NAME': DB_NAME,
        'USER': DB_USER,
        'PASSWORD': DB_PASS,
        'HOST': DB_HOST,
        'PORT': DB_PORT,
        'TEST_USER': 'root',
        'TEST_CHARSET': 'utf8',
        'TEST_COLLATION': 'utf8_general_ci',
        'OPTIONS': {
            'sslmode': 'require',
            'target_session_attrs': 'any'
        },
        'CONN_MAX_AGE': 49,
    },
}

LOGGING['handlers']['file'] = file_handler
LOGGING['loggers']['django']['handlers'] = ['file']

CLICKHOUSE_HOST = os.environ.get('CLICKHOUSE_HOST') # 'vla-kvh4wvcc4lk0uj0s.db.yandex.net'
CLICKHOUSE_PORT = os.environ.get('CLICKHOUSE_PORT')
CLICKHOUSE_PASS = os.environ.get('CLICKHOUSE_PASS')
CLICKHOUSE_USER = os.environ.get('CLICKHOUSE_USER')
CLICKHOUSE_NAME = os.environ.get('CLICKHOUSE_NAME')
