"""volta URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/2.0/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.conf.urls import url, include

from api.views import create_job, create_metric, update_job, rewrite_job_meta, update_metric, delete_job, close_job, \
    resources, job_fragments, unfold_job, job_meta
from common.views import favicon
from job_page.views import get_metrics, get_events, calc_aggregates, get_histograms, get_distributions, \
    get_layout, get_summary, stored_aggregates
from job_page.artifacts.views import get_artifact, get_config
from job_list.views import job_list, job_list_layout, job_list_groups, job_meta_keys
from tastypie.api import Api
from compare.views import compare_layout, get_metrics as get_compare_metrics, \
    get_summary as get_compare_summary, get_aggregates as get_compare_aggregates
from regression.request_schemes import REGRESSION_NAME_PATTERN
from regression.views import get_metrics_meta, get_functions, create_regression, RegressionPage, get_regression_meta, \
    regression_list, regression_list_layout, get_layout as regression_layout, regression_data, regression_meta_keys, \
    add_job_to_regression, delete_job_from_regression

api = Api(api_name='v1')
api.register(resources.JobResource())
api.register(resources.JobMetaResource())
api.register(resources.DataResource())
api.register(resources.DataMetaResource())

urlpatterns = [
    url(r'^.*favicon\.ico/?', favicon),
    url('api/', include(api.urls)),
    url('get_job_meta/', job_meta),
    url('get_job_meta', job_meta),
    url('get_metric/', get_metrics),
    url('get_metrics/', get_metrics),
    url('get_metrics_meta', get_metrics_meta),
    url('get_metrics_meta/', get_metrics_meta),
    url('get_events/', get_events),
    url('get_aggregates/', calc_aggregates),
    url('metrics_aggregates/', calc_aggregates),
    url('get_summary/', get_summary),
    url('get_distributions/', get_distributions),
    url('get_histograms/', get_histograms),
    url('stored_aggregates', stored_aggregates),
    url('get_layout/', get_layout),
    url('create_job/', create_job),
    url('create_metric/', create_metric),
    url('close_job', close_job),
    url('close_job/', close_job),
    url('update_job/', update_job),
    url('update_metric/', update_metric),
    url('rewrite_job_meta/', rewrite_job_meta),
    url('delete_job/', delete_job),
    url('job_list_layout/', job_list_layout),
    url('job_list_layout', job_list_layout),
    url('job_list_groups/', job_list_groups),
    url('job_list_groups', job_list_groups),
    url('job_list/', job_list),
    url('job_list', job_list),
    url('job_meta_keys/', job_meta_keys),
    url('job_meta_keys', job_meta_keys),
    url(r'job/(\d+)/fragments', job_fragments),
    url('compare_layout/', compare_layout),
    url('compare_layout', compare_layout),
    url('compare_metrics', get_compare_metrics),
    url('compare_metrics/', get_compare_metrics),
    url('compare_summary', get_compare_summary),
    url('compare_summary/', get_compare_summary),
    url('compare_aggregates', get_compare_aggregates),
    url('compare_aggregates/', get_compare_aggregates),
    url('unfold_job/', unfold_job),
    url('get_regression_meta', get_regression_meta),
    url('get_regression_functions/', get_functions),
    url('regression/create', create_regression),
    url(r'^regression/(?P<regr_name>{})/$'.format(REGRESSION_NAME_PATTERN), RegressionPage.as_view()),
    url(r'^regression/(?P<regr_name>{})$'.format(REGRESSION_NAME_PATTERN), RegressionPage.as_view()),
    url('regression_list_layout', regression_list_layout),
    url('regression_list', regression_list),
    url('regression_layout', regression_layout),
    url('get_regression_layout', regression_layout),
    url('get_regression_data', regression_data),
    url('regression_meta_keys', regression_meta_keys),
    url(r'regression/(?P<regr_name>{})/add_jobs'.format(REGRESSION_NAME_PATTERN), add_job_to_regression),
    url(r'regression/(?P<regr_name>{})/delete_jobs'.format(REGRESSION_NAME_PATTERN), delete_job_from_regression),
    url(r'artifacts/(?P<job_id>\w+)/(?P<filename>[^/]*)', get_artifact),
    url(r'configs/(?P<job_id>\w+)/(?P<filename>[^/]*)', get_config),
]
