#!/bin/bash
set -e
export DJANGO_SETTINGS_MODULE="settings.${ENV_TYPE}"

sed -i "s/stage/${ENV_TYPE}/" /etc/yandex/environment.type
sed -i "s/stage/${ENV_TYPE}/" /etc/yandex/environment.type.xml

python3 /lunapark/www/manage.py migrate |& tee migration.log
chown www-data:www-data /var/log/lunapark/django/default.log
nginx -g 'daemon off;' -c /etc/nginx/nginx.conf &
exec unbuffer uwsgi --ini build/uwsgi.ini "$@" |& tee /var/log/lunapark/uwsgi.log
