--
-- PostgreSQL database dump
--

-- Dumped from database version 10.16 (Ubuntu 10.16-201)
-- Dumped by pg_dump version 10.12 (Ubuntu 10.12-0ubuntu0.18.04.1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', 'public', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: pg_repack; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS pg_repack WITH SCHEMA public;


--
-- Name: EXTENSION pg_repack; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION pg_repack IS 'Reorganize tables in PostgreSQL databases with minimal locks';


--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- Name: amcheck; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS amcheck WITH SCHEMA public;


--
-- Name: EXTENSION amcheck; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION amcheck IS 'functions for verifying relation integrity';


--
-- Name: heapcheck; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS heapcheck WITH SCHEMA public;


--
-- Name: EXTENSION heapcheck; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION heapcheck IS 'functions for verifying relation integrity';


--
-- Name: pg_stat_statements; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS pg_stat_statements WITH SCHEMA public;


--
-- Name: EXTENSION pg_stat_statements; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION pg_stat_statements IS 'track execution statistics of all SQL statements executed';


--
-- Name: pg_stat_kcache; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS pg_stat_kcache WITH SCHEMA public;


--
-- Name: EXTENSION pg_stat_kcache; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION pg_stat_kcache IS 'Kernel statistics gathering';


--
-- Name: postgres_fdw; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS postgres_fdw WITH SCHEMA public;


--
-- Name: EXTENSION postgres_fdw; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgres_fdw IS 'foreign-data wrapper for remote PostgreSQL servers';


--
-- Name: get_heap_bloat_info(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_heap_bloat_info() RETURNS TABLE(current_database name, schemaname name, tblname name, real_size text, extra_size text, extra_ratio double precision, fillfactor integer, bloat_size text, bloat_size_bytes bigint, bloat_ratio double precision, is_na boolean)
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
BEGIN
RETURN QUERY WITH s AS (
SELECT
        tbl.oid AS tblid, 
	ns.nspname AS schemaname, 
	tbl.relname AS tblname, 
	tbl.reltuples,
        tbl.relpages AS heappages, 
	COALESCE(toast.relpages, 0) AS toastpages,
        COALESCE(toast.reltuples, 0) AS toasttuples,
        COALESCE(substring(array_to_string(tbl.reloptions, ' ')
          FROM '%fillfactor=#"__#"%' FOR '#')::smallint, 100) AS fillfactor,
        current_setting('block_size')::numeric AS bs,
        CASE WHEN version()~'mingw32' OR version()~'64-bit|x86_64|ppc64|ia64|amd64' 
	THEN 8 
	ELSE 4 
	END AS ma,
        24 AS page_hdr,
        23 + CASE WHEN MAX(coalesce(null_frac,0)) > 0 
	THEN ( 7 + count(*) ) / 8 
	ELSE 0::int 
	END
          + CASE WHEN tbl.relhasoids 
	THEN 4 
	ELSE 0 
	END AS tpl_hdr_size,
        sum( (1-coalesce(s.null_frac, 0)) * coalesce(s.avg_width, 1024) ) AS tpl_data_size,
        bool_or(att.atttypid = 'pg_catalog.name'::regtype) AS is_na
FROM pg_attribute AS att
        JOIN pg_class AS tbl ON att.attrelid = tbl.oid
        JOIN pg_namespace AS ns ON ns.oid = tbl.relnamespace
        JOIN pg_stats AS s ON s.schemaname=ns.nspname
          AND s.tablename = tbl.relname AND s.inherited=false AND s.attname=att.attname
        LEFT JOIN pg_class AS toast ON tbl.reltoastrelid = toast.oid
WHERE att.attnum > 0 AND NOT att.attisdropped
        AND tbl.relkind = 'r'
GROUP BY 
	1,2,3,4,5,6,7,8,9,10, tbl.relhasoids
ORDER BY 
	5 DESC
), s2 AS (
SELECT
      	( 4 + tpl_hdr_size + tpl_data_size + (2*ma)
        - CASE WHEN tpl_hdr_size%ma = 0 
	THEN ma 
	ELSE tpl_hdr_size%ma 
	END
        - CASE WHEN ceil(tpl_data_size)::int%ma = 0 
	THEN ma 
	ELSE ceil(tpl_data_size)::int%ma 
	END
      	) AS tpl_size, 
	bs - page_hdr AS size_per_block, 
	(heappages + toastpages) AS tblpages, 
	heappages,
      	toastpages, 
	reltuples, 
	toasttuples, 
	bs, 
	page_hdr, 
	tblid, 
	s.schemaname, 
	s.tblname, 
	s.fillfactor, 
	s.is_na
FROM s
), s3 AS (
SELECT 
	ceil( reltuples / ( (bs-page_hdr)/tpl_size ) ) + ceil( toasttuples / 4 ) AS est_tblpages,
    	ceil( reltuples / ( (bs-page_hdr)*s2.fillfactor/(tpl_size*100) ) ) + ceil( toasttuples / 4 ) AS est_tblpages_ff,
    	s2.tblpages,
    	s2.fillfactor,
    	s2.bs,
    	s2.tblid,
    	s2.schemaname,
    	s2.tblname,
    	s2.heappages,
    	s2.toastpages,
    	s2.is_na
FROM s2
) SELECT
	current_database(),
	s3.schemaname, 
	s3.tblname, 
	pg_size_pretty(bs*s3.tblpages) AS real_size,
	pg_size_pretty(((s3.tblpages-est_tblpages)*bs)::bigint) AS extra_size,
  	CASE WHEN tblpages - est_tblpages > 0
    	THEN 100 * (s3.tblpages - est_tblpages)/s3.tblpages::float
    	ELSE 0
  	END AS extra_ratio, 
	s3.fillfactor, 
	pg_size_pretty(((s3.tblpages-est_tblpages_ff)*bs)::bigint) AS bloat_size,
  	((tblpages-est_tblpages_ff)*bs)::bigint bytes_bloat_size,
  	CASE WHEN s3.tblpages - est_tblpages_ff > 0
    	THEN 100 * (s3.tblpages - est_tblpages_ff)/s3.tblpages::float
    	ELSE 0
  END AS bloat_ratio, s3.is_na
  FROM s3;

END;
$$;


ALTER FUNCTION public.get_heap_bloat_info() OWNER TO postgres;

--
-- Name: get_index_bloat_info(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_index_bloat_info() RETURNS TABLE(dbname name, schema_name name, table_name name, index_name name, bloat_pct numeric, bloat_bytes numeric, bloat_size text, total_bytes numeric, index_size text, table_bytes bigint, table_size text, index_scans bigint)
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$ 
BEGIN

RETURN QUERY WITH btree_index_atts AS (
    SELECT 
	nspname,
	relname,
	reltuples, 
	relpages, 
	indrelid, 
	relam,
        regexp_split_to_table(indkey::text, ' ')::smallint AS attnum,
        indexrelid as index_oid
    FROM pg_index
    JOIN pg_class ON pg_class.oid=pg_index.indexrelid
    JOIN pg_namespace ON pg_namespace.oid = pg_class.relnamespace
    JOIN pg_am ON pg_class.relam = pg_am.oid
    WHERE pg_am.amname = 'btree'
    ),
index_item_sizes AS (
    SELECT
    	i.nspname, 
    	i.relname, 
	i.reltuples, 
	i.relpages, 
	i.relam,
    	s.starelid, 
	a.attrelid AS table_oid, 
	index_oid,
    	current_setting('block_size')::numeric AS bs,
    	/* MAXALIGN: 4 on 32bits, 8 on 64bits (and mingw32 ?) */
    	CASE
        WHEN version() ~ 'mingw32' OR version() ~ '64-bit' 
	THEN 8
        ELSE 4
    	END AS maxalign,
    	24 AS pagehdr,
    	/* per tuple header: add index_attribute_bm if some cols are null-able */
    	CASE WHEN max(coalesce(s.stanullfrac,0)) = 0
	THEN 2
	ELSE 6
    	END AS index_tuple_hdr,
    	/* data len: we remove null values save space using it fractionnal part from stats */
    	SUM( (1-coalesce(s.stanullfrac, 0)) * coalesce(s.stawidth, 2048) ) AS nulldatawidth
    	FROM pg_attribute AS a
    	JOIN pg_statistic AS s ON s.starelid=a.attrelid AND s.staattnum = a.attnum
    	JOIN btree_index_atts AS i ON i.indrelid = a.attrelid AND a.attnum = i.attnum
    	WHERE
		a.attnum > 0
    	GROUP BY 
		1, 2, 3, 4, 5, 6, 7, 8, 9
),
index_aligned AS (
    SELECT 
	maxalign, 
	bs, 
	nspname, 
	relname AS index_name, 
	reltuples,
        relpages, 
	relam, 
	table_oid, 
	index_oid,
      	( 2 + maxalign - 
	CASE /* Add padding to the index tuple header to align on MAXALIGN */
            WHEN index_tuple_hdr%maxalign = 0 
	    THEN maxalign
            ELSE index_tuple_hdr%maxalign
          END
        + nulldatawidth + maxalign - 
	CASE /* Add padding to the data to align on MAXALIGN */
            WHEN nulldatawidth::integer%maxalign = 0 THEN maxalign
            ELSE nulldatawidth::integer%maxalign
          END
      	)::numeric AS nulldatahdrwidth, 
	pagehdr
    FROM index_item_sizes AS s1
),
otta_calc AS (
  SELECT 
	s2.bs,
	s2.nspname, 
	s2.table_oid, 
	s2.index_oid, 
	s2.index_name, 
	s2.relpages, 
	COALESCE(CEIL((reltuples*(4+nulldatahdrwidth))/(bs-pagehdr::float)) +
      	CASE WHEN am.amname IN ('hash','btree') 
	THEN 1 
	ELSE 0 
	END ,
	0 -- btree and hash have a metadata reserved block
    ) AS otta
  FROM index_aligned AS s2
    LEFT JOIN pg_am am ON s2.relam = am.oid
),
raw_bloat AS (
    SELECT 
	current_database() AS dbname, 
	nspname, 
	c.relname AS table_name, 
	sub.index_name,
        bs*(sub.relpages)::bigint AS totalbytes,
        CASE
            WHEN sub.relpages <= otta THEN 0
            ELSE bs*(sub.relpages-otta)::bigint END
            AS wastedbytes,
        CASE
            WHEN sub.relpages <= otta
            THEN 0 
		ELSE bs*(sub.relpages-otta)::bigint * 100 / (bs*(sub.relpages)::bigint) 
		END
        AS realbloat,
        pg_relation_size(sub.table_oid) AS table_bytes,
        stat.idx_scan AS index_scans
    FROM otta_calc AS sub
    JOIN pg_class AS c ON c.oid=sub.table_oid
    JOIN pg_stat_user_indexes AS stat ON sub.index_oid = stat.indexrelid
)
SELECT 
	r.dbname AS database_name, 
	nspname AS schema_name, 
	r.table_name, 
	r.index_name,
        round(realbloat, 1) AS bloat_pct,
        wastedbytes AS bloat_bytes, 
	pg_size_pretty(wastedbytes::bigint) AS bloat_size,
        totalbytes AS index_bytes, 
	pg_size_pretty(totalbytes::bigint) AS index_size,
        r.table_bytes, 
	pg_size_pretty(r.table_bytes) AS table_size,
        r.index_scans
FROM raw_bloat r;
END;
$$;


ALTER FUNCTION public.get_index_bloat_info() OWNER TO postgres;

--
-- Name: postgresdb; Type: SERVER; Schema: -; Owner: postgres
--

CREATE SERVER postgresdb FOREIGN DATA WRAPPER postgres_fdw OPTIONS (
    dbname 'postgres',
    host 'localhost',
    port '6432',
    updatable 'false'
);


ALTER SERVER postgresdb OWNER TO postgres;

--
-- Name: USER MAPPING public SERVER postgresdb; Type: USER MAPPING; Schema: -; Owner: postgres
--

CREATE USER MAPPING FOR public SERVER postgresdb;


--
-- Name: achieve_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.achieve_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.achieve_id_seq OWNER TO lunapark;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: achieve; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.achieve (
    id integer DEFAULT nextval('achieve_id_seq'::regclass) NOT NULL,
    badge_id integer NOT NULL,
    num bigint,
    fd timestamp without time zone NOT NULL,
    td timestamp without time zone,
    type integer NOT NULL,
    wfor bigint NOT NULL,
    user_id integer
);


ALTER TABLE public.achieve OWNER TO lunapark;

--
-- Name: ammo_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.ammo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ammo_id_seq OWNER TO lunapark;

--
-- Name: ammo; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.ammo (
    id integer DEFAULT nextval('ammo_id_seq'::regclass) NOT NULL,
    author character varying(32) NOT NULL,
    created_at timestamp without time zone NOT NULL,
    last_used timestamp without time zone NOT NULL,
    dsc character varying(128) NOT NULL,
    path character varying(256) NOT NULL,
    mdsum character varying(32) NOT NULL,
    size integer NOT NULL,
    flag smallint NOT NULL,
    hidden smallint NOT NULL,
    private smallint NOT NULL
);


ALTER TABLE public.ammo OWNER TO lunapark;

--
-- Name: artifact_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.artifact_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.artifact_id_seq OWNER TO lunapark;

--
-- Name: artifact; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.artifact (
    id integer DEFAULT nextval('artifact_id_seq'::regclass) NOT NULL,
    job_id integer NOT NULL,
    storage_key character varying(256) NOT NULL
);


ALTER TABLE public.artifact OWNER TO lunapark;

--
-- Name: auth_group_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.auth_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.auth_group_id_seq OWNER TO lunapark;

--
-- Name: auth_group; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.auth_group (
    id integer DEFAULT nextval('auth_group_id_seq'::regclass) NOT NULL,
    name character varying(80) NOT NULL
);


ALTER TABLE public.auth_group OWNER TO lunapark;

--
-- Name: auth_group_permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.auth_group_permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.auth_group_permissions_id_seq OWNER TO lunapark;

--
-- Name: auth_group_permissions; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.auth_group_permissions (
    id integer DEFAULT nextval('auth_group_permissions_id_seq'::regclass) NOT NULL,
    group_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE public.auth_group_permissions OWNER TO lunapark;

--
-- Name: auth_permission_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.auth_permission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.auth_permission_id_seq OWNER TO lunapark;

--
-- Name: auth_permission; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.auth_permission (
    id integer DEFAULT nextval('auth_permission_id_seq'::regclass) NOT NULL,
    name character varying(255) NOT NULL,
    content_type_id integer NOT NULL,
    codename character varying(100) NOT NULL
);


ALTER TABLE public.auth_permission OWNER TO lunapark;

--
-- Name: auth_user_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.auth_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.auth_user_id_seq OWNER TO lunapark;

--
-- Name: auth_user; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.auth_user (
    id integer DEFAULT nextval('auth_user_id_seq'::regclass) NOT NULL,
    username character varying(150) NOT NULL,
    first_name character varying(30) NOT NULL,
    last_name character varying(30) NOT NULL,
    email character varying(254) NOT NULL,
    password character varying(128) NOT NULL,
    is_staff boolean NOT NULL,
    is_active boolean NOT NULL,
    is_superuser boolean NOT NULL,
    last_login timestamp without time zone,
    date_joined timestamp without time zone NOT NULL
);


ALTER TABLE public.auth_user OWNER TO lunapark;

--
-- Name: badges_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.badges_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.badges_id_seq OWNER TO lunapark;

--
-- Name: badges; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.badges (
    id integer DEFAULT nextval('badges_id_seq'::regclass) NOT NULL,
    e_name character varying(64) NOT NULL,
    r_name character varying(64) NOT NULL,
    dsc character varying(1024) NOT NULL,
    dsc_s character varying(1024) NOT NULL,
    nums character varying(256),
    color character varying(7)
);


ALTER TABLE public.badges OWNER TO lunapark;

--
-- Name: common_tankuseragent_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.common_tankuseragent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.common_tankuseragent_id_seq OWNER TO lunapark;

--
-- Name: common_tankuseragent; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.common_tankuseragent (
    id integer DEFAULT nextval('common_tankuseragent_id_seq'::regclass) NOT NULL,
    job_id integer NOT NULL,
    user_agent character varying(512) NOT NULL
);


ALTER TABLE public.common_tankuseragent OWNER TO lunapark;

--
-- Name: common_uisettings_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.common_uisettings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.common_uisettings_id_seq OWNER TO lunapark;

--
-- Name: common_uisettings; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.common_uisettings (
    id integer DEFAULT nextval('common_uisettings_id_seq'::regclass) NOT NULL,
    person character varying(64) NOT NULL,
    param character varying(256) NOT NULL,
    onoff smallint NOT NULL
);


ALTER TABLE public.common_uisettings OWNER TO lunapark;

--
-- Name: component_n_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.component_n_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.component_n_seq OWNER TO lunapark;

--
-- Name: component; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.component (
    n integer DEFAULT nextval('component_n_seq'::regclass) NOT NULL,
    name character varying(128) NOT NULL,
    dsc text,
    priority integer NOT NULL,
    include_qs character varying(128) NOT NULL,
    exclude_qs character varying(128) NOT NULL,
    job_order character varying(32) NOT NULL,
    tag character varying(128),
    services_json text
);


ALTER TABLE public.component OWNER TO lunapark;

--
-- Name: custom_user_report_n_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.custom_user_report_n_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.custom_user_report_n_seq OWNER TO lunapark;

--
-- Name: custom_user_report; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.custom_user_report (
    n integer DEFAULT nextval('custom_user_report_n_seq'::regclass) NOT NULL,
    "user" character varying(64) NOT NULL,
    name character varying(32) NOT NULL,
    active smallint NOT NULL,
    plots_json text
);


ALTER TABLE public.custom_user_report OWNER TO lunapark;

--
-- Name: deleted_job; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.deleted_job (
    n integer NOT NULL,
    fd timestamp without time zone DEFAULT now() NOT NULL,
    td timestamp without time zone,
    person character varying(32),
    name character varying(120),
    dsc text,
    tank integer,
    command_line character varying(512),
    ammo_path character varying(256),
    loop_cnt real,
    quit_status smallint,
    srv integer,
    srv_port bigint NOT NULL,
    instances bigint NOT NULL,
    flag smallint,
    component bigint NOT NULL,
    ver character varying(120),
    configinfo text,
    finalized smallint NOT NULL,
    status character varying(32) NOT NULL,
    configinitial text,
    task character varying(120)
);


ALTER TABLE public.deleted_job OWNER TO lunapark;

--
-- Name: django_admin_log_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.django_admin_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.django_admin_log_id_seq OWNER TO lunapark;

--
-- Name: django_admin_log; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.django_admin_log (
    id integer DEFAULT nextval('django_admin_log_id_seq'::regclass) NOT NULL,
    action_time timestamp without time zone NOT NULL,
    user_id integer NOT NULL,
    content_type_id integer,
    object_id text,
    object_repr character varying(200) NOT NULL,
    action_flag integer NOT NULL,
    change_message text NOT NULL
);


ALTER TABLE public.django_admin_log OWNER TO lunapark;

--
-- Name: django_content_type_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.django_content_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.django_content_type_id_seq OWNER TO lunapark;

--
-- Name: django_content_type; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.django_content_type (
    id integer DEFAULT nextval('django_content_type_id_seq'::regclass) NOT NULL,
    app_label character varying(100) NOT NULL,
    model character varying(100) NOT NULL
);


ALTER TABLE public.django_content_type OWNER TO lunapark;

--
-- Name: django_migrations; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.django_migrations (
    id integer NOT NULL,
    app character varying(255) NOT NULL,
    name character varying(255) NOT NULL,
    applied timestamp with time zone NOT NULL
);


ALTER TABLE public.django_migrations OWNER TO lunapark;

--
-- Name: django_migrations_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.django_migrations_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.django_migrations_id_seq OWNER TO lunapark;

--
-- Name: django_migrations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: lunapark
--

ALTER SEQUENCE public.django_migrations_id_seq OWNED BY public.django_migrations.id;


--
-- Name: django_session; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.django_session (
    session_key character varying(40) NOT NULL,
    session_data text NOT NULL,
    expire_date timestamp without time zone NOT NULL
);


ALTER TABLE public.django_session OWNER TO lunapark;

--
-- Name: django_site_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.django_site_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.django_site_id_seq OWNER TO lunapark;

--
-- Name: django_site; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.django_site (
    id integer DEFAULT nextval('django_site_id_seq'::regclass) NOT NULL,
    domain character varying(100) NOT NULL,
    name character varying(50) NOT NULL
);


ALTER TABLE public.django_site OWNER TO lunapark;

--
-- Name: firestarter_jobtank_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.firestarter_jobtank_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.firestarter_jobtank_id_seq OWNER TO lunapark;

--
-- Name: firestarter_jobtank; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.firestarter_jobtank (
    id integer DEFAULT nextval('firestarter_jobtank_id_seq'::regclass) NOT NULL,
    job_id bigint NOT NULL,
    tank integer
);


ALTER TABLE public.firestarter_jobtank OWNER TO lunapark;

--
-- Name: job_n_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.job_n_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.job_n_seq OWNER TO lunapark;

--
-- Name: job; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.job (
    n integer DEFAULT nextval('job_n_seq'::regclass) NOT NULL,
    fd timestamp without time zone DEFAULT now() NOT NULL,
    td timestamp without time zone,
    person character varying(64),
    name character varying(120),
    dsc text,
    tank integer,
    command_line character varying(512),
    ammo_path character varying(256),
    loop_cnt real,
    quit_status smallint,
    srv integer,
    srv_port bigint NOT NULL,
    instances bigint NOT NULL,
    flag smallint NOT NULL,
    component bigint NOT NULL,
    ver character varying(120),
    configinfo text,
    finalized smallint NOT NULL,
    status character varying(32) NOT NULL,
    configinitial text,
    task character varying(120)
);


ALTER TABLE public.job OWNER TO lunapark;

--
-- Name: job_event_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.job_event_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.job_event_id_seq OWNER TO lunapark;

--
-- Name: job_event; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.job_event (
    id integer DEFAULT nextval('job_event_id_seq'::regclass) NOT NULL,
    job_id integer NOT NULL,
    text text,
    author character varying(32),
    "timestamp" timestamp without time zone,
    tag character varying(512)
);


ALTER TABLE public.job_event OWNER TO lunapark;

--
-- Name: job_facts; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.job_facts (
    n integer NOT NULL,
    is_yaml boolean,
    launched_from character varying(64),
    gun character varying(64),
    monitoring_type character varying(64),
    autostop boolean,
    shellexec boolean,
    regression boolean
);


ALTER TABLE public.job_facts OWNER TO lunapark;

--
-- Name: job_imbalance_n_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.job_imbalance_n_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.job_imbalance_n_seq OWNER TO lunapark;

--
-- Name: job_imbalance; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.job_imbalance (
    n integer DEFAULT nextval('job_imbalance_n_seq'::regclass) NOT NULL,
    up integer NOT NULL,
    hum_isimbalance integer NOT NULL,
    hum_imbalance integer NOT NULL,
    rob_isimbalance integer NOT NULL,
    rob_warning_sec integer NOT NULL,
    rob_imbalance integer NOT NULL,
    rob_imbalance_sec integer NOT NULL,
    hum_processed integer NOT NULL,
    "user" character varying(64)
);


ALTER TABLE public.job_imbalance OWNER TO lunapark;

--
-- Name: job_monitoring_config_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.job_monitoring_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.job_monitoring_config_id_seq OWNER TO lunapark;

--
-- Name: job_monitoring_config; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.job_monitoring_config (
    id integer DEFAULT nextval('job_monitoring_config_id_seq'::regclass) NOT NULL,
    job_id integer,
    contents text
);


ALTER TABLE public.job_monitoring_config OWNER TO lunapark;

--
-- Name: job_trail_n_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.job_trail_n_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.job_trail_n_seq OWNER TO lunapark;

--
-- Name: job_trail; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.job_trail (
    n integer DEFAULT nextval('job_trail_n_seq'::regclass) NOT NULL,
    up integer NOT NULL,
    min_rps integer,
    max_rps integer,
    http character varying(64) NOT NULL,
    net integer NOT NULL,
    trail_start timestamp without time zone,
    trail_stop timestamp without time zone,
    avg_expect double precision,
    avg_connect_time double precision,
    avg_send_time double precision,
    avg_latency double precision,
    avg_receive_time double precision,
    q50 double precision,
    q75 double precision,
    q80 double precision,
    q85 double precision,
    q90 double precision,
    q95 double precision,
    q98 double precision,
    q99 double precision,
    avg_resps double precision
);


ALTER TABLE public.job_trail OWNER TO lunapark;

--
-- Name: kpi_n_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.kpi_n_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.kpi_n_seq OWNER TO lunapark;

--
-- Name: kpi; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.kpi (
    n integer DEFAULT nextval('kpi_n_seq'::regclass) NOT NULL,
    component_id bigint NOT NULL,
    essential smallint NOT NULL,
    dsc text,
    ktype character varying(128) NOT NULL,
    params_json text
);


ALTER TABLE public.kpi OWNER TO lunapark;

--
-- Name: loadscheme_n_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.loadscheme_n_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loadscheme_n_seq OWNER TO lunapark;

--
-- Name: loadscheme; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.loadscheme (
    n integer DEFAULT nextval('loadscheme_n_seq'::regclass) NOT NULL,
    up integer NOT NULL,
    sec_from bigint NOT NULL,
    sec_to bigint NOT NULL,
    load_type bigint NOT NULL,
    load_from real NOT NULL,
    load_to real NOT NULL,
    dsc character varying(128) NOT NULL
);


ALTER TABLE public.loadscheme OWNER TO lunapark;

--
-- Name: mobile_apk_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.mobile_apk_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mobile_apk_id_seq OWNER TO lunapark;

--
-- Name: mobile_apk; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.mobile_apk (
    id integer DEFAULT nextval('mobile_apk_id_seq'::regclass) NOT NULL,
    author character varying(32) NOT NULL,
    created_at timestamp without time zone NOT NULL,
    dsc character varying(128) NOT NULL,
    mdsum character varying(32) NOT NULL,
    path character varying(256) NOT NULL,
    size integer NOT NULL
);


ALTER TABLE public.mobile_apk OWNER TO lunapark;

--
-- Name: mobile_apk_tests_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.mobile_apk_tests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mobile_apk_tests_id_seq OWNER TO lunapark;

--
-- Name: mobile_apk_tests; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.mobile_apk_tests (
    id integer DEFAULT nextval('mobile_apk_tests_id_seq'::regclass) NOT NULL,
    author character varying(32) NOT NULL,
    created_at timestamp without time zone NOT NULL,
    dsc character varying(128) NOT NULL,
    mdsum character varying(32) NOT NULL,
    path character varying(256) NOT NULL,
    size integer NOT NULL
);


ALTER TABLE public.mobile_apk_tests OWNER TO lunapark;

--
-- Name: mobile_data_key_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.mobile_data_key_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mobile_data_key_id_seq OWNER TO lunapark;

--
-- Name: mobile_data_key; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.mobile_data_key (
    id integer DEFAULT nextval('mobile_data_key_id_seq'::regclass) NOT NULL,
    job_id integer NOT NULL,
    mobile_data_key character varying(256) NOT NULL
);


ALTER TABLE public.mobile_data_key OWNER TO lunapark;

--
-- Name: mobile_device_storage_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.mobile_device_storage_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mobile_device_storage_id_seq OWNER TO lunapark;

--
-- Name: mobile_device_storage; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.mobile_device_storage (
    id integer DEFAULT nextval('mobile_device_storage_id_seq'::regclass) NOT NULL,
    device_serial character varying(120),
    location_type character varying(32),
    location_name character varying(120),
    modified timestamp without time zone NOT NULL
);


ALTER TABLE public.mobile_device_storage OWNER TO lunapark;

--
-- Name: mobile_job_n_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.mobile_job_n_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mobile_job_n_seq OWNER TO lunapark;

--
-- Name: mobile_job; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.mobile_job (
    n integer DEFAULT nextval('mobile_job_n_seq'::regclass) NOT NULL,
    task character varying(120),
    test_id character varying(120),
    name character varying(120),
    dsc text,
    fd timestamp without time zone NOT NULL,
    td timestamp without time zone,
    tank character varying(512),
    device_id character varying(512),
    device_model character varying(512),
    device_os character varying(512),
    app character varying(512),
    ver character varying(512),
    quit_status integer,
    flag smallint NOT NULL,
    component bigint,
    finalized smallint NOT NULL,
    status character varying(32) NOT NULL,
    person character varying(64),
    test_start bigint,
    sys_uts_offset bigint,
    log_uts_offset bigint,
    sync_sample bigint,
    version character varying(512),
    meta text
);


ALTER TABLE public.mobile_job OWNER TO lunapark;

--
-- Name: mobilepage_mobilecomponent_n_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.mobilepage_mobilecomponent_n_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mobilepage_mobilecomponent_n_seq OWNER TO lunapark;

--
-- Name: mobilepage_mobilecomponent; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.mobilepage_mobilecomponent (
    n integer DEFAULT nextval('mobilepage_mobilecomponent_n_seq'::regclass) NOT NULL,
    name character varying(128) NOT NULL,
    dsc text,
    job_order character varying(32) NOT NULL,
    tag character varying(128)
);


ALTER TABLE public.mobilepage_mobilecomponent OWNER TO lunapark;

--
-- Name: monitoring_metric_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.monitoring_metric_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.monitoring_metric_id_seq OWNER TO lunapark;

--
-- Name: monitoring_metric; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.monitoring_metric (
    id integer DEFAULT nextval('monitoring_metric_id_seq'::regclass) NOT NULL,
    name character varying(255) NOT NULL,
    code character varying(100) NOT NULL,
    description character varying(5000) NOT NULL,
    created_at timestamp without time zone NOT NULL,
    modified_at timestamp without time zone NOT NULL
);


ALTER TABLE public.monitoring_metric OWNER TO lunapark;

--
-- Name: pandora_binary; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.pandora_binary (
    id integer NOT NULL,
    author character varying(32) NOT NULL,
    created_at timestamp without time zone NOT NULL,
    last_used timestamp without time zone NOT NULL,
    dsc character varying(128) NOT NULL,
    path character varying(256) NOT NULL,
    mdsum character varying(32) NOT NULL,
    size integer NOT NULL,
    flag smallint NOT NULL,
    hidden smallint NOT NULL,
    private smallint NOT NULL
);


ALTER TABLE public.pandora_binary OWNER TO lunapark;

--
-- Name: pandora_binary_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.pandora_binary_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pandora_binary_id_seq OWNER TO lunapark;

--
-- Name: pandora_binary_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: lunapark
--

ALTER SEQUENCE public.pandora_binary_id_seq OWNED BY public.pandora_binary.id;


--
-- Name: regression_comment_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.regression_comment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.regression_comment_id_seq OWNER TO lunapark;

--
-- Name: regression_comment; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.regression_comment (
    id integer DEFAULT nextval('regression_comment_id_seq'::regclass) NOT NULL,
    job_id integer NOT NULL,
    text character varying(256),
    author character varying(32) NOT NULL,
    created_at timestamp without time zone
);


ALTER TABLE public.regression_comment OWNER TO lunapark;

--
-- Name: repl_mon; Type: FOREIGN TABLE; Schema: public; Owner: postgres
--

CREATE FOREIGN TABLE public.repl_mon (
    ts timestamp with time zone,
    location text,
    replics integer,
    master text
)
SERVER postgresdb
OPTIONS (
    schema_name 'public',
    table_name 'repl_mon'
);


ALTER FOREIGN TABLE public.repl_mon OWNER TO postgres;

--
-- Name: server_n_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.server_n_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.server_n_seq OWNER TO lunapark;

--
-- Name: server; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.server (
    n integer DEFAULT nextval('server_n_seq'::regclass) NOT NULL,
    host character varying(128) NOT NULL,
    is_test smallint,
    fd timestamp without time zone DEFAULT now() NOT NULL,
    td timestamp without time zone,
    config text,
    dsc text,
    last_ip character varying(20),
    last_dc integer
);


ALTER TABLE public.server OWNER TO lunapark;

--
-- Name: south_migrationhistory_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.south_migrationhistory_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.south_migrationhistory_id_seq OWNER TO lunapark;

--
-- Name: south_migrationhistory; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.south_migrationhistory (
    id integer DEFAULT nextval('south_migrationhistory_id_seq'::regclass) NOT NULL,
    app_name character varying(255) NOT NULL,
    migration character varying(255) NOT NULL,
    applied timestamp without time zone NOT NULL
);


ALTER TABLE public.south_migrationhistory OWNER TO lunapark;

--
-- Name: task_n_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.task_n_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.task_n_seq OWNER TO lunapark;

--
-- Name: task; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.task (
    n integer DEFAULT nextval('task_n_seq'::regclass) NOT NULL,
    key character varying(64)
);


ALTER TABLE public.task OWNER TO lunapark;

--
-- Name: task_server_n_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.task_server_n_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.task_server_n_seq OWNER TO lunapark;

--
-- Name: task_server; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.task_server (
    n integer DEFAULT nextval('task_server_n_seq'::regclass) NOT NULL,
    openstack_id character varying(64),
    status character varying(16),
    task character varying(120)
);


ALTER TABLE public.task_server OWNER TO lunapark;

--
-- Name: tastypie_apiaccess; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.tastypie_apiaccess (
    id integer NOT NULL,
    identifier character varying(255) NOT NULL,
    url character varying(255) NOT NULL,
    request_method character varying(10) NOT NULL,
    accessed integer NOT NULL,
    CONSTRAINT tastypie_apiaccess_accessed_check CHECK ((accessed >= 0))
);


ALTER TABLE public.tastypie_apiaccess OWNER TO lunapark;

--
-- Name: tastypie_apiaccess_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.tastypie_apiaccess_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tastypie_apiaccess_id_seq OWNER TO lunapark;

--
-- Name: tastypie_apiaccess_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: lunapark
--

ALTER SEQUENCE public.tastypie_apiaccess_id_seq OWNED BY public.tastypie_apiaccess.id;


--
-- Name: tastypie_apikey; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.tastypie_apikey (
    id integer NOT NULL,
    user_id integer NOT NULL,
    key character varying(256) NOT NULL,
    created timestamp with time zone NOT NULL
);


ALTER TABLE public.tastypie_apikey OWNER TO lunapark;

--
-- Name: tastypie_apikey_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.tastypie_apikey_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tastypie_apikey_id_seq OWNER TO lunapark;

--
-- Name: tastypie_apikey_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: lunapark
--

ALTER SEQUENCE public.tastypie_apikey_id_seq OWNED BY public.tastypie_apikey.id;


--
-- Name: thanks_id_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.thanks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.thanks_id_seq OWNER TO lunapark;

--
-- Name: thanks; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.thanks (
    id integer DEFAULT nextval('thanks_id_seq'::regclass) NOT NULL,
    date timestamp without time zone NOT NULL,
    text text NOT NULL,
    job_id integer,
    to_user_id integer,
    from_user_id integer
);


ALTER TABLE public.thanks OWNER TO lunapark;

--
-- Name: upload_token_n_seq; Type: SEQUENCE; Schema: public; Owner: lunapark
--

CREATE SEQUENCE public.upload_token_n_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.upload_token_n_seq OWNER TO lunapark;

--
-- Name: upload_token; Type: TABLE; Schema: public; Owner: lunapark
--

CREATE TABLE public.upload_token (
    n integer DEFAULT nextval('upload_token_n_seq'::regclass) NOT NULL,
    job bigint,
    token character varying(64) NOT NULL
);


ALTER TABLE public.upload_token OWNER TO lunapark;

--
-- Name: django_migrations id; Type: DEFAULT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.django_migrations ALTER COLUMN id SET DEFAULT nextval('django_migrations_id_seq'::regclass);


--
-- Name: pandora_binary id; Type: DEFAULT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.pandora_binary ALTER COLUMN id SET DEFAULT nextval('pandora_binary_id_seq'::regclass);


--
-- Name: tastypie_apiaccess id; Type: DEFAULT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.tastypie_apiaccess ALTER COLUMN id SET DEFAULT nextval('tastypie_apiaccess_id_seq'::regclass);


--
-- Name: tastypie_apikey id; Type: DEFAULT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.tastypie_apikey ALTER COLUMN id SET DEFAULT nextval('tastypie_apikey_id_seq'::regclass);


--
-- Name: achieve achieve_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.achieve
    ADD CONSTRAINT achieve_id_pkey PRIMARY KEY (id);


--
-- Name: ammo ammo_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.ammo
    ADD CONSTRAINT ammo_id_pkey PRIMARY KEY (id);


--
-- Name: artifact artifact_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.artifact
    ADD CONSTRAINT artifact_id_pkey PRIMARY KEY (id);


--
-- Name: auth_group auth_group_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.auth_group
    ADD CONSTRAINT auth_group_id_pkey PRIMARY KEY (id);


--
-- Name: auth_group_permissions auth_group_permissions_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_id_pkey PRIMARY KEY (id);


--
-- Name: auth_permission auth_permission_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.auth_permission
    ADD CONSTRAINT auth_permission_id_pkey PRIMARY KEY (id);


--
-- Name: auth_user auth_user_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.auth_user
    ADD CONSTRAINT auth_user_id_pkey PRIMARY KEY (id);


--
-- Name: badges badges_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.badges
    ADD CONSTRAINT badges_id_pkey PRIMARY KEY (id);


--
-- Name: common_tankuseragent common_tankuseragent_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.common_tankuseragent
    ADD CONSTRAINT common_tankuseragent_id_pkey PRIMARY KEY (id);


--
-- Name: common_uisettings common_uisettings_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.common_uisettings
    ADD CONSTRAINT common_uisettings_id_pkey PRIMARY KEY (id);


--
-- Name: component component_n_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.component
    ADD CONSTRAINT component_n_pkey PRIMARY KEY (n);


--
-- Name: custom_user_report custom_user_report_n_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.custom_user_report
    ADD CONSTRAINT custom_user_report_n_pkey PRIMARY KEY (n);


--
-- Name: deleted_job deleted_job_n_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.deleted_job
    ADD CONSTRAINT deleted_job_n_pkey PRIMARY KEY (n);


--
-- Name: django_admin_log django_admin_log_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.django_admin_log
    ADD CONSTRAINT django_admin_log_id_pkey PRIMARY KEY (id);


--
-- Name: django_content_type django_content_type_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.django_content_type
    ADD CONSTRAINT django_content_type_id_pkey PRIMARY KEY (id);


--
-- Name: django_migrations django_migrations_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.django_migrations
    ADD CONSTRAINT django_migrations_pkey PRIMARY KEY (id);


--
-- Name: django_session django_session_session_key_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.django_session
    ADD CONSTRAINT django_session_session_key_pkey PRIMARY KEY (session_key);


--
-- Name: django_site django_site_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.django_site
    ADD CONSTRAINT django_site_id_pkey PRIMARY KEY (id);


--
-- Name: firestarter_jobtank firestarter_jobtank_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.firestarter_jobtank
    ADD CONSTRAINT firestarter_jobtank_id_pkey PRIMARY KEY (id);


--
-- Name: job_event job_event_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.job_event
    ADD CONSTRAINT job_event_id_pkey PRIMARY KEY (id);


--
-- Name: job_facts job_facts_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.job_facts
    ADD CONSTRAINT job_facts_pkey PRIMARY KEY (n);


--
-- Name: job_imbalance job_imbalance_n_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.job_imbalance
    ADD CONSTRAINT job_imbalance_n_pkey PRIMARY KEY (n);


--
-- Name: job_monitoring_config job_monitoring_config_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.job_monitoring_config
    ADD CONSTRAINT job_monitoring_config_pkey PRIMARY KEY (id);


--
-- Name: job job_n_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.job
    ADD CONSTRAINT job_n_pkey PRIMARY KEY (n);


--
-- Name: job_trail job_trail_n_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.job_trail
    ADD CONSTRAINT job_trail_n_pkey PRIMARY KEY (n);


--
-- Name: kpi kpi_n_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.kpi
    ADD CONSTRAINT kpi_n_pkey PRIMARY KEY (n);


--
-- Name: loadscheme loadscheme_n_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.loadscheme
    ADD CONSTRAINT loadscheme_n_pkey PRIMARY KEY (n);


--
-- Name: mobile_apk mobile_apk_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.mobile_apk
    ADD CONSTRAINT mobile_apk_pkey PRIMARY KEY (id);


--
-- Name: mobile_apk_tests mobile_apk_tests_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.mobile_apk_tests
    ADD CONSTRAINT mobile_apk_tests_pkey PRIMARY KEY (id);


--
-- Name: mobile_data_key mobile_data_key_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.mobile_data_key
    ADD CONSTRAINT mobile_data_key_id_pkey PRIMARY KEY (id);


--
-- Name: mobile_device_storage mobile_device_storage_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.mobile_device_storage
    ADD CONSTRAINT mobile_device_storage_id_pkey PRIMARY KEY (id);


--
-- Name: mobile_job mobile_job_n_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.mobile_job
    ADD CONSTRAINT mobile_job_n_pkey PRIMARY KEY (n);


--
-- Name: mobilepage_mobilecomponent mobilepage_mobilecomponent_n_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.mobilepage_mobilecomponent
    ADD CONSTRAINT mobilepage_mobilecomponent_n_pkey PRIMARY KEY (n);


--
-- Name: monitoring_metric monitoring_metric_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.monitoring_metric
    ADD CONSTRAINT monitoring_metric_id_pkey PRIMARY KEY (id);


--
-- Name: pandora_binary pandora_binary_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.pandora_binary
    ADD CONSTRAINT pandora_binary_id_pkey PRIMARY KEY (id);


--
-- Name: regression_comment regression_comment_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.regression_comment
    ADD CONSTRAINT regression_comment_id_pkey PRIMARY KEY (id);


--
-- Name: server server_n_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.server
    ADD CONSTRAINT server_n_pkey PRIMARY KEY (n);


--
-- Name: south_migrationhistory south_migrationhistory_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.south_migrationhistory
    ADD CONSTRAINT south_migrationhistory_id_pkey PRIMARY KEY (id);


--
-- Name: task task_n_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.task
    ADD CONSTRAINT task_n_pkey PRIMARY KEY (n);


--
-- Name: task_server task_server_n_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.task_server
    ADD CONSTRAINT task_server_n_pkey PRIMARY KEY (n);


--
-- Name: tastypie_apiaccess tastypie_apiaccess_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.tastypie_apiaccess
    ADD CONSTRAINT tastypie_apiaccess_pkey PRIMARY KEY (id);


--
-- Name: tastypie_apikey tastypie_apikey_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.tastypie_apikey
    ADD CONSTRAINT tastypie_apikey_pkey PRIMARY KEY (id);


--
-- Name: tastypie_apikey tastypie_apikey_user_id_key; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.tastypie_apikey
    ADD CONSTRAINT tastypie_apikey_user_id_key UNIQUE (user_id);


--
-- Name: thanks thanks_id_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.thanks
    ADD CONSTRAINT thanks_id_pkey PRIMARY KEY (id);


--
-- Name: upload_token upload_token_n_pkey; Type: CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.upload_token
    ADD CONSTRAINT upload_token_n_pkey PRIMARY KEY (n);


--
-- Name: achieve_badge_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX achieve_badge_id ON public.achieve USING btree (badge_id);


--
-- Name: achieve_user_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX achieve_user_id ON public.achieve USING btree (user_id);


--
-- Name: artifact_job_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX artifact_job_id ON public.artifact USING btree (job_id);


--
-- Name: auth_group_name; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE UNIQUE INDEX auth_group_name ON public.auth_group USING btree (name);


--
-- Name: auth_group_permissions_group_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX auth_group_permissions_group_id ON public.auth_group_permissions USING btree (group_id);


--
-- Name: auth_group_permissions_group_id_permission_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE UNIQUE INDEX auth_group_permissions_group_id_permission_id ON public.auth_group_permissions USING btree (group_id, permission_id);


--
-- Name: auth_group_permissions_permission_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX auth_group_permissions_permission_id ON public.auth_group_permissions USING btree (permission_id);


--
-- Name: auth_permission_content_type_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX auth_permission_content_type_id ON public.auth_permission USING btree (content_type_id);


--
-- Name: auth_permission_content_type_id_codename; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE UNIQUE INDEX auth_permission_content_type_id_codename ON public.auth_permission USING btree (content_type_id, codename);


--
-- Name: auth_user_username; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE UNIQUE INDEX auth_user_username ON public.auth_user USING btree (username);


--
-- Name: common_tankuseragent_job_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX common_tankuseragent_job_id ON public.common_tankuseragent USING btree (job_id);


--
-- Name: deleted_job_srv; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX deleted_job_srv ON public.deleted_job USING btree (srv);


--
-- Name: deleted_job_tank; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX deleted_job_tank ON public.deleted_job USING btree (tank);


--
-- Name: django_admin_log_content_type_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX django_admin_log_content_type_id ON public.django_admin_log USING btree (content_type_id);


--
-- Name: django_admin_log_user_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX django_admin_log_user_id ON public.django_admin_log USING btree (user_id);


--
-- Name: django_content_type_app_label_model; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE UNIQUE INDEX django_content_type_app_label_model ON public.django_content_type USING btree (app_label, model);


--
-- Name: django_session_expire_date; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX django_session_expire_date ON public.django_session USING btree (expire_date);


--
-- Name: firestarter_jobtank_tank; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX firestarter_jobtank_tank ON public.firestarter_jobtank USING btree (tank);


--
-- Name: job_component; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX job_component ON public.job USING btree (component);


--
-- Name: job_event_job_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX job_event_job_id ON public.job_event USING btree (job_id);


--
-- Name: job_imbalance_up; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX job_imbalance_up ON public.job_imbalance USING btree (up);


--
-- Name: job_monitoring_config_job_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX job_monitoring_config_job_id ON public.job_monitoring_config USING btree (job_id);


--
-- Name: job_n; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX job_n ON public.job USING btree (n);


--
-- Name: job_srv; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX job_srv ON public.job USING btree (srv);


--
-- Name: job_tank; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX job_tank ON public.job USING btree (tank);


--
-- Name: job_trail_up; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX job_trail_up ON public.job_trail USING btree (up);


--
-- Name: mobile_data_key_job_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX mobile_data_key_job_id ON public.mobile_data_key USING btree (job_id);


--
-- Name: monitoring_metric_code; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX monitoring_metric_code ON public.monitoring_metric USING btree (code);


--
-- Name: regression_comment_job_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX regression_comment_job_id ON public.regression_comment USING btree (job_id);


--
-- Name: tastypie_apikey_key; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX tastypie_apikey_key ON public.tastypie_apikey USING btree (key);


--
-- Name: thanks_from_user_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX thanks_from_user_id ON public.thanks USING btree (from_user_id);


--
-- Name: thanks_to_user_id; Type: INDEX; Schema: public; Owner: lunapark
--

CREATE INDEX thanks_to_user_id ON public.thanks USING btree (to_user_id);


--
-- Name: achieve achieve_badge_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.achieve
    ADD CONSTRAINT achieve_badge_id_fkey FOREIGN KEY (badge_id) REFERENCES badges(id);


--
-- Name: achieve achieve_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.achieve
    ADD CONSTRAINT achieve_user_id_fkey FOREIGN KEY (user_id) REFERENCES auth_user(id);


--
-- Name: artifact artifact_job_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.artifact
    ADD CONSTRAINT artifact_job_id_fkey FOREIGN KEY (job_id) REFERENCES job(n);


--
-- Name: common_tankuseragent common_tankuseragent_job_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.common_tankuseragent
    ADD CONSTRAINT common_tankuseragent_job_id_fkey FOREIGN KEY (job_id) REFERENCES job(n);


--
-- Name: deleted_job deleted_job_srv_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.deleted_job
    ADD CONSTRAINT deleted_job_srv_fkey FOREIGN KEY (srv) REFERENCES server(n);


--
-- Name: deleted_job deleted_job_tank_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.deleted_job
    ADD CONSTRAINT deleted_job_tank_fkey FOREIGN KEY (tank) REFERENCES server(n);


--
-- Name: django_admin_log django_admin_log_content_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.django_admin_log
    ADD CONSTRAINT django_admin_log_content_type_id_fkey FOREIGN KEY (content_type_id) REFERENCES django_content_type(id);


--
-- Name: django_admin_log django_admin_log_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.django_admin_log
    ADD CONSTRAINT django_admin_log_user_id_fkey FOREIGN KEY (user_id) REFERENCES auth_user(id);


--
-- Name: firestarter_jobtank firestarter_jobtank_tank_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.firestarter_jobtank
    ADD CONSTRAINT firestarter_jobtank_tank_fkey FOREIGN KEY (tank) REFERENCES server(n);


--
-- Name: job job_component_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.job
    ADD CONSTRAINT job_component_fkey FOREIGN KEY (component) REFERENCES component(n);


--
-- Name: job_event job_event_job_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.job_event
    ADD CONSTRAINT job_event_job_id_fkey FOREIGN KEY (job_id) REFERENCES job(n);


--
-- Name: job_facts job_facts_n_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.job_facts
    ADD CONSTRAINT job_facts_n_fkey FOREIGN KEY (n) REFERENCES job(n);


--
-- Name: job_imbalance job_imbalance_up_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.job_imbalance
    ADD CONSTRAINT job_imbalance_up_fkey FOREIGN KEY (up) REFERENCES job(n);


--
-- Name: job job_srv_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.job
    ADD CONSTRAINT job_srv_fkey FOREIGN KEY (srv) REFERENCES server(n);


--
-- Name: job job_tank_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.job
    ADD CONSTRAINT job_tank_fkey FOREIGN KEY (tank) REFERENCES server(n);


--
-- Name: job_trail job_trail_up_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.job_trail
    ADD CONSTRAINT job_trail_up_fkey FOREIGN KEY (up) REFERENCES job(n);


--
-- Name: mobile_data_key mobile_data_key_job_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.mobile_data_key
    ADD CONSTRAINT mobile_data_key_job_id_fkey FOREIGN KEY (job_id) REFERENCES job(n);


--
-- Name: regression_comment regression_comment_job_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.regression_comment
    ADD CONSTRAINT regression_comment_job_id_fkey FOREIGN KEY (job_id) REFERENCES job(n);


--
-- Name: thanks thanks_from_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.thanks
    ADD CONSTRAINT thanks_from_user_id_fkey FOREIGN KEY (from_user_id) REFERENCES auth_user(id);


--
-- Name: thanks thanks_to_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.thanks
    ADD CONSTRAINT thanks_to_user_id_fkey FOREIGN KEY (to_user_id) REFERENCES auth_user(id);


--
-- Name: tastypie_apikey user_id_refs_id_990aee10; Type: FK CONSTRAINT; Schema: public; Owner: lunapark
--

ALTER TABLE ONLY public.tastypie_apikey
    ADD CONSTRAINT user_id_refs_id_990aee10 FOREIGN KEY (user_id) REFERENCES auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: SCHEMA public; Type: ACL; Schema: -; Owner: postgres
--

GRANT USAGE ON SCHEMA public TO monitor;


--
-- Name: FUNCTION pg_stat_reset(); Type: ACL; Schema: pg_catalog; Owner: postgres
--

GRANT ALL ON FUNCTION pg_catalog.pg_stat_reset() TO mdb_admin;


--
-- Name: TABLE pg_stat_statements; Type: ACL; Schema: public; Owner: postgres
--

GRANT SELECT ON TABLE public.pg_stat_statements TO monitor;


--
-- Name: TABLE pg_stat_kcache_detail; Type: ACL; Schema: public; Owner: postgres
--

GRANT SELECT ON TABLE public.pg_stat_kcache_detail TO monitor;


--
-- Name: TABLE pg_stat_kcache; Type: ACL; Schema: public; Owner: postgres
--

GRANT SELECT ON TABLE public.pg_stat_kcache TO monitor;


--
-- Name: TABLE pg_stat_ucache; Type: ACL; Schema: public; Owner: postgres
--

GRANT SELECT ON TABLE public.pg_stat_ucache TO monitor;


--
-- Name: TABLE repl_mon; Type: ACL; Schema: public; Owner: postgres
--

GRANT SELECT ON TABLE public.repl_mon TO PUBLIC;


--
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: public; Owner: postgres
--

ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA public REVOKE ALL ON TABLES  FROM postgres;
ALTER DEFAULT PRIVILEGES FOR ROLE postgres IN SCHEMA public GRANT SELECT,INSERT,DELETE,UPDATE ON TABLES  TO lunapark WITH GRANT OPTION;


--
-- PostgreSQL database dump complete
--

