(function(){
	"use strict";
	
	$(".type_choose_button").on('click',
			function (event) {
				var type = this.id.split("__")[1];
					$(".bb_jobsauto").hide();
					$(".bb_jobsauto_alt").hide();
					$(".type_choose_button_active").removeClass("active");
					$(".type_choose_button_active").removeClass("type_choose_button_active");
					$("#bb_jobsauto__" + type).show();
					$("#bb_jobsauto_alt__" + type).show();
					$("#type_choose_button__" + type).addClass("active");
					$("#type_choose_button__" + type).addClass("type_choose_button_active");
					$("#type_choose_button__" + type).addClass("active");
					$("#type_choose_button_alt__" + type).addClass("type_choose_button_active");
				event.preventDefault();
				event.stopPropagation();
	});

	
	$(".bb_year_switch").on('click',
			function (event) {
				$(this).unbind();
				$(this).css('cursor', 'default');
				var type = this.id.split("__")[1];
				var year = parseInt($("#bb_year").html());
				$('#bb_'+year+'_body').html('');
				$('#bb_'+year+'_body').append('<i class="fa fa-circle-o-notch fa-spin" aria-hidden="true"></i>');
				if(type=="left"){
					var new_year = year-1
				}
				else if (type=="right"){
					var new_year = year+1
				}
				$("#bb_year").html(new_year);
				window.location.assign("/bb/?year=" + new_year)
	});
	
	var year = $('#bb_year').text();
	var url = "/bb/plot_data?year=" + year;

	$.getJSON(url).done(function(data){
			var xValues = data.xaxis.map(function(mo) {
				var val = new Date();
				val.setDate(1);
				val.setMonth(mo - 1);
				return val
			});
			var cfg={
					chart: {
			            renderTo: $("div#bbplot")[0],
			            height: 300,
			        },
			        series: data.series,
			        yAxis: {
			        	showFirstLabel: false, 
			        	min: 0,
			        	title: {
			        		text: '',
			        	},
			        },
			        title: {
			   			text: '',
			        },
			        navigator: {
			            enabled: false,
			        },
			        rangeSelector: {
			        	enabled: false,
			        },
			        scrollbar: {
			        	enabled: false,
			        },
			        exporting: {
			            enabled: false,
			        },
			        credits: {
			        	enabled: false,
			        },
			        plotOptions: {
						spline : {
							lineWidth : 2,
							zIndex : 1,
							shadow : false
							},
			        },
			        tooltip : {
			        	animation : false,
						useHTML: true,
						formatter: function() {
							// formatting tooltip
							var res = '';
							res += '<small style="font-weight: bold; align: center;">' + data.week_labels[this.x] + '</small><br>';
							res += '<table class="tooltip_table">';
							$.each(this.points, function(i, point) {
								res += '<tr style="padding:0; margin:0;">' +
								'<td style="background-color: rgba(255,255,255,0.2); padding:0 0 0 0.2em; margin:0; text-align: left;">' + 
								'<span style="color: ' + this.series.color + ';">' +
								this.series.name + ': </span></td>' + 
								'<td style="width:100%; background-color: rgba(255,255,255,0.2); padding:0 0 0 1em; margin:0; text-align: right;">' +
								'<span style="font-weight: bold; color: ' + this.series.color + ';">' +
								this.y + 
								'</span></td>' + 
								'</tr>';
							});
							res += '</table>';
							return res
						},
						shared : true,
						borderRadius : 2,
						borderWidth : 1,
						crosshairs : {
							width : 1,
							color : 'gray',
							dashStyle : 'shortdot',
							zIndex: 3
						},
					},
					xAxis: {
			            showFirstLabel: true, 
			            showLastLabel: true, 
			            labels: {
			            	overflow: 'justify',
			            	formatter: function() {
		                        var lbl = data.week_labels[this.value];
		                        return lbl;
		                    }
		            	},
					},
					legend : {
						align : 'center',
						verticalAlign : 'bottom',
						itemStyle : {
							color : 'black'
						},
						reversed: true,
						borderWidth : 0
					}
			};
			
			var chart=new Highcharts.Chart(cfg);						
	}).fail().always();
		
})();
