/*
 * Объект страницы сравнения
 */

(function() {

	String.prototype.replaceAll = function(search, replacement) {
		var target = this;
		return target.split(search).join(replacement);
	};

	String.prototype.endsWith = function(suffix) {
        return this.indexOf(suffix, this.length - suffix.length) !== -1;
    };

	function testForEnter(event) {
		if (event.key === "Enter") {
			$("#submitAddCompare").click()
		}
	}

	var COLORS = [
	    '#2f7ed8',
        '#f28f43',
        '#8bbc21',
        '#910000',
        '#1aadce',
        '#492970',
        '#77a1e5',
        '#c42525',
        '#a6c96a'
    ];

	function bindJobRemoval() {
	    var $controllers = $(".removeJobFromCompare");
        $controllers.off();
        $controllers.on('click', function(event){
            var job_n = $(this).data('job');
            var url = '/compare/remove_jobs';
            $.post(url, {
                    "jobs" : job_n
                }).success(function(data) {
                    if (data && data["success"] === 1) {
                        $('#comparepage_menu_link').find('a')[0].click();
                    }
                }, 'json');
            return false;
	    });
    }

    bindJobRemoval();

    $("#submitAddCompare").click(function() {
        var jobs = $('#addJobsToCompare').val();
        if (jobs){
            var url = '/compare/add_jobs';
            $.post(url, {
                "jobs" : jobs
            }).success(function(data) {
                if (data) {
                    if (data.success === 1) {
                        $(".b_compare_count").html(data.count);
                        if (data.count > 0) {
                            $(".b_compare_count__delete").show();
                        } else {
                            $(".b_compare_count__delete").hide();
                        }
                        $('#comparepage_menu_link').find('a')[0].click();
                    }
                }
            }, 'json');
        }
    });

    new CompareView();

	function CompareView() {
	    var parsedHash = getUrlVars();
		getJobs(parsedHash);
	}

	function getJobs(parsedHash) {
		var jobs = parsedHash["jobs"] ? parsedHash["jobs"] : '';
		var jobs_url = '';
		if (jobs) {
			jobs_url = '/compare/reset_jobs.json';
			$.ajax({
				url : jobs_url,
				type : 'POST',
                data: {"jobs": jobs},
				dataType : 'json'
			});
			setMetainfo(jobs);
			getLayout(jobs, parsedHash)
		}
		else {
			jobs = $("#jobs_numbers").text();
			if (!jobs) {
				jobs_url = '/compare/get_compare_jobs.json';
				$.ajax({
					url : jobs_url,
					type : 'GET',
					dataType : 'json'
				}).success(function(data) {
				    if (data.jobs) {
				        jobs = data.jobs
                    } else {
				        window.location = '/compare/no_compare_jobs'
                    }
				});
			}
			getLayout(jobs, parsedHash)
		}
	}

	function setMetainfo(jobs) {
		var compareMetaJobTemplate = _.template($('#compareMetaJobTemplate').text());
		jobs = jobs.split(',');
		var $jobsControls = $('#jobsControls');
		$jobsControls.html('');
		for (var j=0; j<jobs.length;j++) {
		    var job = jobs[j];
            $.ajax({
                url: '/api/v2/jobs/'+job,
                type: 'GET',
                dataType: 'json',
                async: false
            }).success(function(data) {
                var jobsCount = $('.jobMetaRow').length;
                $jobsControls.append(compareMetaJobTemplate({n: data['n'], name: data['name'], color: COLORS[jobsCount % COLORS.length]}));
            });
		}
		var jobsCount = $('.jobMetaRow').length;
		$(".b_compare_count").html(jobsCount);
		if (jobsCount > 0) {
		     $(".b_compare_count__delete").show();
        } else {
            $(".b_compare_count__delete").hide();
        }
        bindJobRemoval();
	}

	function getLayout(jobs, parsedHash) {
        var url = '/compare/layout.json?jobs=' + jobs;
        $.ajax({
            url: url,
            type: 'GET',
            dataType: 'json'
        }).success(function (layout) {
            if (typeof layout === 'string') {
                layout = JSON.parse(layout);
            }
            makeTabPanel(layout, parsedHash, jobs);
        }).fail(function () {
            var msg = ('Error while layout loading!');
            console.log(msg);
        });
	}

/*
 * Панель с табами
 */

	function makeTabPanel(layout, parsedHash, jobs) {
		var $tabPanel = $("ul#tab_panel"),
            tab;
		if (parsedHash) {
			tab = parsedHash.tab
		}
		else {
			tab = null
		}

        for (var n = 0; n < layout.length; n++){
            $tabPanel.append('<li style="cursor: pointer;" class="nav-item tab_panel_tab_inactive" id="tab_panel_tab__'+layout[n].name+'"><a class="nav-link tab_panel_tab_link" data-tab="'+layout[n].name+'" id="tab_panel_tab_link__'+layout[n].name+'">'+layout[n].title+'</a></li>')
        }
        $('a.tab_panel_tab_link').click(
                function(event) {
                            $('#controls_panel').show();
                            var tab = this.id.split("__")[1];
                            setActiveTab(tab);
                            makeControlPanel(layout, tab, jobs);
                            var $mainjobs_radio = $('#mainjob_radio');
                            var plotGroup = $('button.plotGroup_radio_label.active')[0].id.split("__")[1];
                            var metricGroup = $('button.metricGroup_radio_label.active')[0].id.split("__")[1];

                            if (tab === "monitoring" && metricGroup === "aggregates" || plotGroup === "tables" && tab === "test_data") {
                                $mainjobs_radio.show()
                            }
                            else {
                                $mainjobs_radio.hide()
                            }
                            event.stopPropagation();
                            event.preventDefault();
        });
        setActiveTab(tab);
        var active_tab = $("a.active");
        active_tab.click();
        tab = active_tab.data('tab');
        makeControlPanel(layout, tab, jobs);
        var plotGroup = $('button.plotGroup_radio_label.active')[0].id.split("__")[1];
        var metricGroup = $('button.metricGroup_radio_label.active')[0].id.split("__")[1];

        if (tab === "monitoring" && metricGroup === "aggregates" || plotGroup === "tables" && tab === "test_data") {
            $mainjobs_radio.show()
        }
        else {
            $mainjobs_radio.hide()
        }
	}

	function setActiveTab(tab) {
		$("div#compare_plots").html('<i class="fa fa-circle-o-notch fa-spin" aria-hidden="true"></i>');
		var $new_active;
		if (!tab) {
			$new_active = $("#tab_panel li:first-child a");
			$new_active.removeClass("tab_panel_tab_inactive");
			$new_active.addClass("active");
		}
		else {
			var previous_active = $("a.active");
			previous_active.removeClass("active");
			previous_active.addClass("tab_panel_tab_inactive");
			$new_active = $("#tab_panel_tab__" + tab + " a");
			$new_active.removeClass("tab_panel_tab_inactive");
			$new_active.addClass("active");
		}
	}
/**
 * Панель с контролами
 */

	function makeControlPanel(layout, tab, jobs) {
		var parsedHash = getUrlVars();
		var controls_panel = $("div#controls_panel");
		var krutilka = controls_panel.find(".controls_krutilka");
		krutilka.show();
		var controls = getObjects(layout, 'name', tab)[0].controls;
		krutilka.hide();

		// jobs
		var $mainjobs_radio = controls_panel.find('#mainjob_radio')[0];
		if ($mainjobs_radio === undefined) {
			controls_panel.append('<div class="btn-group btn-group-sm controls" role="group" aria-label="..." id="mainjob_radio"></div><br>');
			$mainjobs_radio = $('#mainjob_radio');
			for (var n in jobs.split(",")){
				$mainjobs_radio.append('<button type="button" class="btn btn-secondary mainjob_radio_label" id="mainjob_radio__'+jobs.split(",")[n]+'" value="'+jobs.split(",")[n]+'">'+jobs.split(",")[n]+'</button>')
			}
			var labels = document.getElementsByClassName('mainjob_radio_label');
			// переключалка кнопок
			$mainjobs_radio.find('button.mainjob_radio_label').unbind();
			$mainjobs_radio.find('button.mainjob_radio_label').bind('click',
                function(event) {
                    var parsedHash = getUrlVars();
                    tab = parsedHash["tab"];
                    var mainjob = this.id.split("__")[1];
                    setActiveLabel("mainjob", mainjob);
                    loadPlotsList(tab, jobs);
                    event.stopPropagation();
                    event.preventDefault();
			    });
			// дефолтные действия при создании страницы (без переключения кнопок)
			var hashedMainjob;
			try {
				hashedMainjob = parsedHash["mainjob"]
			}
			catch (e) {
				hashedMainjob = ''
			}
			if (hashedMainjob) {
				setActiveLabel("mainjob", hashedMainjob)
			}
			else {
				setActiveLabel("mainjob", undefined)
			}
		}
		// helpers
		var helper_radio = controls_panel.find('#helper_radio')[0];
		if (helper_radio === undefined) {
		    controls_panel.append('<div class="btn-group btn-group-sm controls" role="group" aria-label="..." id="helper_radio"></div><br>');
			var helpers = controls[0].helpers,
				helpers_radio = $('#helper_radio');
			for (var n=0; n < helpers.length; n++){
				helpers_radio.append('<button type="button" class="btn btn-secondary helper_radio_label" id="helper_radio__'+helpers[n][0]+'" value="'+helpers[n][0]+'">'+helpers[n][1]+'</button>')
			}
			// переключалка кнопок
			helpers_radio.find('button.helper_radio_label').unbind();
			helpers_radio.find('button.helper_radio_label').bind('click',
                function(event) {
			        var parsedHash = getUrlVars();
                    tab = parsedHash["tab"];
                    var helper = this.id.split("__")[1];
                    setActiveLabel("helper", helper);
                    loadPlotsList(tab, jobs);
                    event.stopPropagation();
                    event.preventDefault();
			});
			// дефолтные действия при создании страницы (без переключения кнопок)

            var hashedHelper;
			try {
				hashedHelper = parsedHash["helper"]
			}
			catch (e) {
				hashedHelper = ''
			}
			if (hashedHelper) {
				setActiveLabel("helper", hashedHelper)
			}
			else {
				setActiveLabel("helper", undefined)
			}
		}
		var case_radio,
		    plotGroup_radio,
		    target_radio,
		    metricGroup_radio;
		if (tab === "monitoring") {
			case_radio = controls_panel.find('#case_radio')[0];
			plotGroup_radio = controls_panel.find('#plotGroup_radio')[0];
			if (case_radio !== undefined && plotGroup_radio !== undefined) {
				$('#case_radio').hide();
				$('#plotGroup_radio').hide()
			}
			// targets
			target_radio = controls_panel.find('#target_radio')[0];
			if (target_radio === undefined) {
			    controls_panel.append('<div class="btn-group btn-group-sm controls" role="group" aria-label="..." id="target_radio"></div>');
				var targets = controls[1].values,
					targets_radio = $("#target_radio");
				for (var n=0; n < targets.length; n++) {
					targets_radio.append('<button type="button" class="btn btn-secondary target_radio_label" id="target_radio__'+targets[n][0]+'" value="'+targets[n][0]+'">'+targets[n][1]+'</button>')
				}
				// переключалка кнопок
				targets_radio.find('button.target_radio_label').unbind();
				targets_radio.find('button.target_radio_label').bind('click',
						function(event) {
									var tar = this.id.split("__")[1];
									setActiveLabel("target", tar);
									loadPlotsList(tab, jobs);
									event.stopPropagation();
									event.preventDefault();
				});
				// дефолтные действия при создании страницы (без переключения кнопок)
				var hashedTarget;
				try {
					hashedTarget = parsedHash["target"]
				}
				catch (e) {
					hashedTarget = ''
				}
				if (hashedTarget) {
					setActiveLabel("target", hashedTarget)
				}
				else {
					setActiveLabel("target", undefined)
				}
			}
			else {
				$('#target_radio').show()
			}

			// metric_groups
			metricGroup_radio = controls_panel.find('#metricGroup_radio')[0];
			if (metricGroup_radio === undefined) {
			    controls_panel.append('<div class="btn-group btn-group-sm controls" role="group" aria-label="..." id="metricGroup_radio"></div>');
				var metricGroups = controls[2].values,
					metricGroups_radio = $("#metricGroup_radio");
				for (var n=0; n < metricGroups.length; n++){
					metricGroups_radio.append('<button type="button" class="btn btn-secondary metricGroup_radio_label" id="metricGroup_radio__'+metricGroups[n][0]+'" value="'+metricGroups[n][0]+'">'+metricGroups[n][1]+'</button>')
				}
				// переключалка кнопок
				metricGroups_radio.find('button.metricGroup_radio_label').unbind();
				metricGroups_radio.find('button.metricGroup_radio_label').bind('click',
						function(event) {
									var metricGroup = this.id.split("__")[1];
									var $mainjobs_radio = $('#mainjob_radio');
									if (metricGroup === "aggregates") {
										$mainjobs_radio.show();
										setActiveLabel("metricGroup", metricGroup);
										loadPlotsList(tab, jobs)
									}
									else {
										$mainjobs_radio.hide();
										setActiveLabel("metricGroup", metricGroup);
										loadPlotsList(tab, jobs)
									}
									event.stopPropagation();
									event.preventDefault();
				});
				// дефолтные действия при создании страницы (без переключения кнопок)
				var hashedMetricGroup;
				try {
					hashedMetricGroup = parsedHash["metricGroup"]
				}
				catch (e) {
					hashedMetricGroup = ''
				}

				if (hashedMetricGroup) {
					setActiveLabel("metricGroup", hashedMetricGroup)
				}
				else {
					setActiveLabel("metricGroup", undefined)
				}
			}
			else {
				$('#metricGroup_radio').show()
			}
		}
		if (tab === "test_data") {
			target_radio = controls_panel.find('#target_radio')[0];
            metricGroup_radio = controls_panel.find('#metricGroup_radio')[0];
			if (target_radio !== undefined && metricGroup_radio !== undefined) {
				$('#target_radio').hide();
				$('#metricGroup_radio').hide()
			}
			// plot_groups
			plotGroup_radio = controls_panel.find('#plotGroup_radio')[0];
			if (plotGroup_radio === undefined) {
				controls_panel.append('<div class="btn-group btn-group-sm controls" role="group" aria-label="..." id="plotGroup_radio"></div>');
				var plotGroups = controls[1].values,
					plotGroups_radio = $("#plotGroup_radio");
				for (var n=0; n < plotGroups.length; n++) {
					plotGroups_radio.append('<button type="button" class="btn btn-secondary plotGroup_radio_label" id="plotGroup_radio__' + plotGroups[n][0] + '" value="' + plotGroups[n][0] + '">' + plotGroups[n][1] + '</button>')
				}
				// переключалка кнопок
				plotGroups_radio.find('button.plotGroup_radio_label').unbind();
				plotGroups_radio.find('button.plotGroup_radio_label').bind('click',
						function(event) {
									var plotGroup = this.id.split("__")[1];
									setActiveLabel("plotGroup", plotGroup);
									loadPlotsList(tab, jobs);
									event.stopPropagation();
									event.preventDefault();
				});
				// дефолтные действия при создании страницы (без переключения кнопок)
                var hashedPlotGroup;
				try {
					hashedPlotGroup = parsedHash["plotGroup"]
				}
				catch (e) {
					hashedPlotGroup = ''
				}
				if (hashedPlotGroup) {
					setActiveLabel("plotGroup", hashedPlotGroup)
				}
				else {
					setActiveLabel("plotGroup", undefined)
				}
			}
			else {
				$('#plotGroup_radio').show()
			}
			// cases
			case_radio = controls_panel.find('#case_radio')[0];
			if (case_radio === undefined) {
				var cases = controls[2].values;
				controls_panel.append('<div class="btn-group btn-group-sm controls" role="group" aria-label="..." id="case_radio"></div>');
				var cases_radio = $("#case_radio");

				for (var n=0; n < cases.length; n++){
					var case_id = encodeURIComponent(cases[n][0]);
					cases_radio.append('<button type="button" class="btn btn-secondary case_radio_label" id="case_radio__'+case_id+'" value="'+case_id+'">'+cases[n][1].replace(/</g, "&lt;").replace(/>/g, "&gt;")+'</button>')
				}
				// переключалка кнопок
				cases_radio.find('button.case_radio_label').unbind();
				cases_radio.find('button.case_radio_label').bind('click',
						function(event) {
									var cases = this.id.split("__")[1].replace(/\;/g, '\\\;');
									setActiveLabel("case", cases);
									loadPlotsList(tab, jobs);
									event.stopPropagation();
									event.preventDefault();
				});
				// дефолтные действия при создании страницы (без переключения кнопок)
				var hashedCase;
				try {
					hashedCase = parsedHash["cases"]
				}
				catch (e) {
					hashedCase = ''
				}
				if (hashedCase) {
					setActiveLabel("case", encodeURIComponent(hashedCase))
				}
				else {
					setActiveLabel("case", '')
				}
			}
			else {
				$('#case_radio').show()
			}
		}
		if (tab !== "meta_info") {
			controls_panel.show();
			loadPlotsList(tab, jobs)
		}
		else {
			controls_panel.hide();
			loadPlotsList(tab, jobs)
        }
    }
    function setActiveLabel(type, label) {
		/**
		 * Если новая страница без хэша, то
		 * Кнопки с mainjob скрываются для графиков и показываются для таблиц.
		 */
		var $new_active,
		    $mainjobs_radio;
		if (label === undefined) {
			$new_active = $('#'+type+'_radio button:first-child');
			$new_active.addClass("active");
			$new_active.unbind();
			$mainjobs_radio = $('#mainjob_radio');
			if (type === "plotGroup" && $new_active[0].id.split("__")[1] === "tables") {
				$mainjobs_radio.show()
			}
			if (type === "plotGroup" && $new_active[0].id.split("__")[1] !== "tables") {
				$mainjobs_radio.hide()
			}
			if (type === "metricGroup" && label === "aggregates") {
				$mainjobs_radio.show()
			}
			if (type === "metricGroup" && label !== "aggregates") {
				$mainjobs_radio.hide()
			}
		}
		else {
			var previous_active = $('button.'+type+'_radio_label.active');
            $new_active = $('button[id="'+type+'_radio__'+label+'"]');
			$new_active.unbind();
			if (previous_active[0] === undefined) {
				$new_active.addClass('active');
				$mainjobs_radio = $('#mainjob_radio');
				if (type === "plotGroup" && label === "tables") {
					$mainjobs_radio.show()
				}
				if (type === "plotGroup" && label !== "tables") {
					$mainjobs_radio.hide()
				}
				if (type === "metricGroup" && label === "aggregates") {
					$mainjobs_radio.show()
				}
				if (type === "metricGroup" && label !== "aggregates") {
					$mainjobs_radio.hide()
				}
			}
			if (previous_active[0] !== undefined && previous_active[0].id !== $new_active.id){
				previous_active.removeClass('active');
				previous_active.bind('click',
					function(event) {
                        var parsedHash = getUrlVars();
						var tab = parsedHash["tab"];
						var jobs = parsedHash["jobs"];
						var metricGroup = parsedHash[""];
						var cases = this.id.split("__")[1];
						var type = this.id.split("_")[0];
						setActiveLabel(type, cases);
						loadPlotsList(tab, jobs);
						event.stopPropagation();
						event.preventDefault();
					}
				);
				$new_active.addClass('active');
				$mainjobs_radio = $('#mainjob_radio');
				if (type === "plotGroup" && label === "tables") {
					$mainjobs_radio.show()
				}
				if (type === "plotGroup" && label !== "tables") {
					$mainjobs_radio.hide()
				}
				if (type === "metricGroup" && label === "aggregates") {
					$mainjobs_radio.show()
				}
				if (type === "metricGroup" && label !== "aggregates") {
					$mainjobs_radio.hide()
				}
			}
		}
    }
	/*
 * Список графиков
 */

	function loadPlotsList(tab, jobs) {
		for (var i=0; i < Highcharts.charts.length; i++) {
			if (Highcharts.charts[i] !== undefined) {
				Highcharts.charts[i].destroy()
			}
		}
		//Highcharts.charts = Highcharts.charts.filter(function(n){ return n != undefined });
        var parsedHash = getUrlVars();
		var plot_list = $('div#compare_plots');
		plot_list.html('<i class="krutilka fa fa-circle-o-notch fa-spin" aria-hidden="true"></i>');

		var mainjob,
            helper,
            cases,
            plotGroup,
            metricGroup,
            tar,
            url,
            toHash,
            hash,
            hashKeys,
            newHash,
            newVal;

		if (tab === 'meta_info') {
            mainjob = parsedHash["mainjob"];
            helper = parsedHash["helper"];
            cases = parsedHash["case"];
            plotGroup = parsedHash["plot_group"];
            metricGroup = parsedHash["metric_group"];
            tar = parsedHash["target"];
            url = '/compare/plots_to_show.json?jobs='+jobs+'&mainjob='+mainjob+'&tab='+tab;
            toHash = {
                    "tab": tab,
                    "mainjob": mainjob,
                    "helper": helper,
                    "cases": cases,
                    "plotGroup": plotGroup,
                    "metricGroup": metricGroup,
                    "target": tar,
            };
            hash = window.location.hash;
			if (hash) {
				hashKeys = Object.keys(parsedHash);
				hash = '';
				for (var k=0; k < hashKeys.length; k++) {
					newVal = toHash[hashKeys[k]];
					if (newVal === undefined) {
						hash += '&' + hashKeys[k] + '=' + parsedHash[hashKeys[k]]
					}
					else {
						hash += '&' + hashKeys[k] + '=' + newVal
					}
				}
				window.location.hash = hash.slice(1)
			}
			else {
				hashKeys = Object.keys(toHash);
				newHash = 'jobs=' + jobs;
				for (var k=0; k < hashKeys.length; k++) {
					newVal = toHash[hashKeys[k]];
					if (newVal === undefined) {
						newHash += '&' + hashKeys[k] + '='
					}
					else {
						newHash += '&' + hashKeys[k] + '=' + newVal
					}
				}
				window.location.hash = newHash
			}

			$.getJSON(url)
			.done(function(data) {
				for ( var n = 0; n < data.plots_to_show.length; n++) {
					plot_list.append('<div class="col-xl-12 compare_plot_container" id="compare_plot_container__' + data.plots_to_show[n].replaceAll(':', '_').replaceAll(' ', '_').replaceAll('.', '_') + '"></div>');
					getPlotData(data.plots_to_show[n])
				}
				plot_list.find(".krutilka").remove();
			}).fail(function() {
				plot_list.text("Failed to get plots list for " + tab);
			});
		}
		else {
		    try {
				mainjob = $('button.mainjob_radio_label.active')[0].id.split("__")[1]
			} catch (e) {mainjob = undefined}
			try {
				helper = $('button.helper_radio_label.active')[0].id.split("__")[1]
			} catch (e) {helper = undefined}
			try {
				cases = $('button.case_radio_label.active')[0].id.split("__")[1]
			} catch (e) {cases = undefined}
			try {
				plotGroup = $('button.plotGroup_radio_label.active')[0].id.split("__")[1]
			} catch (e) {plotGroup = undefined}
			try {
				metricGroup = $('button.metricGroup_radio_label.active')[0].id.split("__")[1]
			} catch (e) {metricGroup = undefined}
			try {
				tar = $('button.target_radio_label.active')[0].id.split("__")[1]
			} catch (e) {tar = undefined}

			toHash = {
					"tab": tab,
					"mainjob": mainjob,
					"helper": helper,
					"cases": cases,
					"plotGroup": plotGroup,
					"metricGroup": metricGroup,
					"target": tar,
			};

			hash = window.location.hash;

			if (hash) {
				hashKeys = Object.keys(parsedHash);
				hash = '';
				for (var k=0; k < hashKeys.length; k++) {
					newVal = toHash[hashKeys[k]];
					if (newVal === undefined) {
						hash += '&' + hashKeys[k] + '=' + parsedHash[hashKeys[k]]
					}
					else {
						hash += '&' + hashKeys[k] + '=' + newVal
					}
				}
				window.location.hash = hash.slice(1)
			}
			else {
				hashKeys = Object.keys(toHash);
				newHash = 'jobs=' + jobs;
				for (var k=0; k < hashKeys.length; k++) {
					newVal = toHash[hashKeys[k]];
					if (newVal === undefined) {
						newHash += '&' + hashKeys[k] + '='
					}
					else {
						newHash += '&' + hashKeys[k] + '=' + newVal
					}
				}
				window.location.hash = newHash
			}
			if (plotGroup === undefined) {
				plotGroup = ""
			}
			if (cases === undefined) {
				cases = ""
			}
			if (tar === undefined) {
				tar = ""
			}
			if (metricGroup === undefined) {
				metricGroup = ""
			}
			if (tab === "monitoring") {
				url = '/compare/plots_to_show.json?jobs='+jobs+'&mainjob='+mainjob+'&tab='+tab+'&helper='+helper+'&target='+tar+'&metric_group='+metricGroup;
				$.getJSON(url)
				.done(function(data) {
					if (data["plots_to_show"][0]) {
						for ( var n = 0; n < data.plots_to_show.length; n++) {
							var newPlotType = data.plots_to_show[n].replaceAll(':', '_').replaceAll(' ', '_').replaceAll('.', '_');
							plot_list.append('<div class="col-xl-12 compare_plot_container" id="compare_plot_container__' + newPlotType + '"></div>');
							getPlotData(data.plots_to_show[n])
						}
					}
					else {
						var targ = $('label#target_radio_label__' + tar).find('span.b-form-radio__text').text();
						plot_list.append('<h1 style="padding-top: 2em;" class="plot_title">'+metricGroup +' @ '+targ+'</h1><div style="width: 99%; height: 330px; align:center"><div style="padding: 3em 0; text-align: center; color: #3E576F; font-size: 300%;">Нет Данных</div></div>')
					}
				}).fail(function() {
					plot_list.text("Failed to get plots list for " + tab);
				}).always(function() {
					plot_list.find(".krutilka").remove();
				});
			}
			else {
				url = '/compare/plots_to_show.json?jobs='+jobs+'&mainjob='+mainjob+'&tab='+tab+'&helper='+helper+'&plot_group='+plotGroup+'&case='+cases;
				$.getJSON(url)
				.done(function(data) {
					for ( var n = 0; n < data.plots_to_show.length; n++) {
					    var viewportClass = "col-xl-12";
					    var newPlotType = data.plots_to_show[n].replaceAll(':', '_').replaceAll(' ', '_').replaceAll('.', '_');
					    if (newPlotType.endsWith("table")) {
					        viewportClass = "col-xl-6";
                        }
						plot_list.append('<div class="'+viewportClass+' compare_plot_container" id="compare_plot_container__' + newPlotType + '"></div>');
						getPlotData(data.plots_to_show[n])
					}
				}).fail(function() {
					plot_list.text("Failed to get plots list for " + tab);
				}).always(function() {
					plot_list.find(".krutilka").remove();
				});
			}

		}

}

/*
 * Рисуем график или таблицу
 */

	function getPlotData(plotType) {
	    var parsedHash = getUrlVars();
		var tar = parsedHash["target"];
		if (tar === undefined) {
			tar = ""
		}
		var cases = parsedHash["cases"];

		if (cases === undefined) {
			cases = [""]
		}
		cases = [encodeURIComponent(cases)];
		var selector = parsedHash[plotType];
		var url;
		if (selector) {
			url = '/compare/plot_data.json?selector='+selector+'&jobs=' + parsedHash.jobs + '&mainjob=' + parsedHash.mainjob + '&tab=' + parsedHash.tab + '&target=' +tar+ '&case=' + cases + '&helper=' + parsedHash.helper + '&plot_type=' + plotType
		}
		else {
			url = '/compare/plot_data.json?jobs=' + parsedHash.jobs + '&mainjob=' + parsedHash.mainjob + '&tab=' + parsedHash.tab + '&target=' +tar+ '&case=' + cases + '&helper=' + parsedHash.helper + '&plot_type=' + plotType
		}
		var container = $('div#compare_plot_container__' + plotType.replaceAll(':', '_').replaceAll(' ', '_').replaceAll('.', '_'));
		$.getJSON(url).done(function(data) {
		    container.html('');
			draw(data, plotType, selector)
		}).fail(function() {
			container.text("Failed to get plot data for " + plotType);
		}).always(function() {
			$('#plot_'+plotType+'_krutilka').hide()
		});
		return url
    }
    function draw(data, plotType, selector) {
		if (data.table) {
			drawTable(data, plotType, selector)
		}
		else {
			drawPlot(data, plotType, selector)
		}
    }
    function drawTable(data, plotType, selector) {
	    var parsedHash = getUrlVars();

		var container = $('div#compare_plot_container__' + plotType.replaceAll(':', '_').replaceAll(' ', '_').replaceAll('.', '_'));
		container.addClass("col-sm-12");
		container.addClass("table_decoration");
		container.append('<h4>'+data.title+'</h4>');
		container.append('<ul class="nav nav-pills selectors_table" id="selectors__' + plotType + '"></ul>');

		// переключение типа данных (количество, проценты и прочее)
		var selectorsTable = $('#selectors__'+plotType);
		if (data.data.selectors) {
			var selectors = data.data.selectors;
			for (var j=0; j<selectors.length; j++) {
				var sel = selectors[j][0];
				selectorsTable.append('<li style="cursor: pointer;" class="nav-item table_selector" id="table_selector__'+sel+'__'+ plotType +'"><a tabindex="0" style="padding: 0.25em 0.5em; font-size: 11pt;" class="nav-link">'+selectors[j][1]+'</a></li></ul>');
				$('#table_selector__'+sel+'__'+ plotType).bind('click',
					function(event) {
				        var parsedHash = getUrlVars();
                        var hash = window.location.hash;
                        var sel = this.id.split("__")[1];
                        var plotType = this.id.split("__")[2];
                        if (parsedHash[plotType]){
                            var hashKeys = Object.keys(parsedHash);
                            var newHash = '';
                            for (var k=0; k < hashKeys.length; k++) {
                                if (hashKeys[k] === plotType) {
                                    newHash += '&' + plotType + '=' + sel
                                }
                                else {
                                    newHash += '&' + hashKeys[k] + '=' + parsedHash[hashKeys[k]]
                                }
                            }
                            window.location.hash = newHash.slice(1)
                        }
                        else {
                            window.location.hash = hash + '&' + plotType + '=' + sel
                        }
                        var dash = window.location.hash;
                        var container = $('div#compare_plot_container__' + plotType);
                        getPlotData(plotType);
                        event.stopPropagation();
                        event.preventDefault();
                        }
				)
			}
			if (selector) {
				$("#table_selector__" + selector + "__" + plotType).find('a').addClass("active")
			}
			else {
				if (data.data.default_selector) {
					$("#table_selector__" + data.data.default_selector + "__" + plotType).find('a').addClass("active")
				}
				else {
					$("#table_selector__count__" + plotType).find('a').addClass("active")
				}
			}
		}
		container.append('<table style="width: 100%" class="table table-sm table-striped table-hover" id="' + plotType + '"><thead id="table_head__' + plotType + '"></thead><tbody id="table_body__' + plotType + '"></tbody></table>');
		var table = $('table#'+plotType),
		tableHead = $('#table_head__'+plotType),
		tableBody = $('#table_body__'+plotType);
		tableHead.append('<tr id="jobsRow_'+plotType+'"></tr>');
		var jobsRow = $('tr#jobsRow_'+plotType);
		jobsRow.append('<th></th>');
		for (var value in data.data.columns['n']) {
            jobsRow.append('<th id="comparepage_table_job_cell__'+value+'" style="text-align: right;"><a title="'+data.data.columns['n'][value].split(" | ")[1]+'" href="/'+data.data.columns['n'][value].split("__")[0]+'">'+data.data.columns['n'][value].split("__")[0]+'</a></th>');
            jobsRow.append('<th></th>'); // for diff cell
		}
		var row_keys = data.data.row_keys;
		for (var i=0; i<row_keys.length; i++) {
			key = row_keys[i];
			if (key !== 'n') {
				tableBody.append('<tr id="row_'+plotType+'__'+key.replace('.','_')+'"></tr>');
				var row = $('tr#row_'+plotType+'__'+key.replace('.','_'));
				if (plotType==='trail_times_table') {
					row.append('<td class="comparepage_table_row_cell" style="font-weight: bold; text-align: right;">'+data.data.rows[key]+'</td>')
				}
				else {
					row.append('<td class="comparepage_table_row_cell" style="font-weight: bold; text-align: left;">'+data.data.rows[key].replace(/</g, "&lt;").replace(/>/g, "&gt;")+'</td>')
				}
				j=0;
				for (var value in data.data.columns[key]) {
					var cell = data.data.columns[key][value].split('diff:')[0];
					if (cell && cell.toString().indexOf(".") > 0 && plotType !== 'meta_info_table') {
						cell = cell.toString().replace('\%', ' \%');
						var fraction = cell.split('.')[1].split(' ')[0];
						while (fraction && fraction.length < 3) {
							fraction = fraction + '0'
						}
						var valueText = cell.split('.')[0] + '.<span style="font-size:80%; opacity: 0.6;">' + fraction + '</span>';
						if (cell.split('.')[1].indexOf(" ") > 0) {
							valueText += ' ' + cell.split('.')[1].split(' ')[1]
						}
					}
					else {
						var valueText = cell
					}
					row.append('<td class="comparepage_table_value_cell" id="comparepage_table_value_cell__'+plotType+'__'+key.replace('.','_')+'_'+j+'" style="border-right:none; text-align:right;">'+valueText+'</td>');
					var diff = data.data.columns[key][value].split('diff:')[1];
					if (diff === undefined || plotType === 'meta_info_table') {
						diff = "";
					}
					if (diff && diff.toString().indexOf(".") > 0 && plotType !== 'meta_info_table') {
						diff = diff.toString().replace('\%', ' \%');
						var fraction = diff.split('.')[1].split(' ')[0];
						while (fraction && fraction.length < 3) {
							fraction = fraction + '0'
						}
						var diffText = '<span>(</span>' + diff.split('.')[0] + '.<span style="font-size:80%;">' + fraction + '</span><span>)</span>';
						if (diff.split('.')[1].indexOf(" ") > 0) {
							diffText += ' ' + diff.split('.')[1].split(' ')[1]
						}
					}
					else {
						if (plotType !== 'meta_info_table'){
							var diffText = '(' + diff.toString() + ')'
						}
						else {
							var diffText = ''
						}
					}
					var colorMap = {"+":"DarkGoldenRod ", "-":"DarkCyan", "0":"gray", undefined:"gray", "":"gray"};
					var color = colorMap[diff[0]];
					row.append('<td class="comparepage_table_diff_cell" id="comparepage_table_diff_cell__'+plotType+'__'+key.replace('.','_')+'_'+j+'" style="padding-left:0; text-align: left; color: '+color+';">'+diffText+'</td>');
					$('td#comparepage_table_diff_cell__'+plotType+'__'+key.replace('.','_')+'_'+j+'').children().css('color', color);
					if (!diff && plotType !== "meta_info_table") {
						var vcell = $('td#comparepage_table_value_cell__'+plotType+'__'+key.replace('.','_')+'_'+j),
							dcell = $('td#comparepage_table_diff_cell__'+plotType+'__'+key.replace('.','_')+'_'+j);
						dcell.text(data.data.dim);
						vcell.css('color','#3C763D');
						dcell.css('color','#3C763D')
					}
					j+=1
				}
				if (plotType === "meta_info_table" && !data.data.mask[key]) {
					$('tr#row_meta_info_table__'+key.replace('.','_')).addClass('warning')
				}
			}
		}
}
    function drawPlot(data, plotType, selector) {
		var plotTypeOriginal = plotType;
        plotType = plotType.replaceAll(':', '_').replaceAll(' ', '_').replaceAll('.', '_');
        var container = $('div#compare_plot_container__' + plotType);
		container.addClass("plot_decoration");
		container.html('');
		container.append('<div class="plot_title">'+data.title+'</div>');
		container.append('<div class="plot_subtitle">'+data.subtitle.replace(/</g, "&lt;").replace(/>/g, "&gt;")+'</div>');
		if (data["compress_ratio"]) {
			container.append('<div class="compress_ratio" id="compress_ratio__'+plotType+'"><span>' + data["compress_ratio"] + ' сек. в точке</span></div>')
		}
		// переключение типа данных (количество, проценты и прочее)

		if (data.data.selectors) {
			container.append('<div class="plot_header_block" id="plot_header_block__'+plotType+'"><table class="plot_selectors"><tr><ul class="nav nav-pills" id="selectorsRow__'+plotType+'"></ul></tr></table></div>');
			var selectorsRow = $('#selectorsRow__'+plotType);
			var selectors = data.data.selectors;
			for (var j=0; j<selectors.length; j++) {
				var sel = selectors[j][0];
				selectorsRow.append('<li style="cursor: pointer;" class="nav-item" role="presentation" id="plot_selector__'+sel+'__'+plotType+'"><a tabindex="0" style="padding: 0.25em 0.5em; font-size: 11pt;" class="nav-link plot_selector_radio_label plot_selector_' + plotType+'" >'+selectors[j][1]+'</a></li>');
				$('#plot_selector__'+sel+'__'+ plotType).bind('click',
					function(event) {
                        var parsedHash = getUrlVars();
                        var hash = window.location.hash;
                        var sel = this.id.split("__")[1];
                        var plotType = this.id.split("__")[2];
                        if (parsedHash[plotTypeOriginal]){
                            var hashKeys = Object.keys(parsedHash);
                            var newHash = '';
                            for (var k=0; k < hashKeys.length; k++) {
                                if (hashKeys[k] === plotTypeOriginal) {
                                    newHash += '&' + plotTypeOriginal + '=' + sel
                                }
                                else {
                                    newHash += '&' + hashKeys[k] + '=' + parsedHash[hashKeys[k]]
                                }
                            }
                            window.location.hash = newHash.slice(1)
                        }
                        else {
                            window.location.hash = hash + '&' + plotTypeOriginal + '=' + sel
                        }
                        var dash = window.location.hash;
                        var container = $('div#compare_plot_container__' + plotType);
                        container.css({"min-width": container.width(), "min-height": container.height()});
                        getPlotData(plotTypeOriginal);
                        event.stopPropagation();
                        event.preventDefault();
                        }
				)
			}
			if (selector) {
				$("#plot_selector__" + selector + "__" + plotType).find('a').addClass("active")
			}
			else {
				$("#plot_selector__" + data.data.default_selector + "__" + plotType).find('a').addClass("active")
			}
		}
		container.append('<div class="chart_container" id="plot_container__' + plotType + '"></div>');

		/**
	     * Override the reset function, we don't need to hide the tooltips and crosshairs.
		 * Reset the tracking by hiding the tooltip, the hover series state and the hover point
		 *
		 * @param allowMove {Boolean} Instead of destroying the tooltip altogether, allow moving it if possible
		 */


	    var each = function(arr, fn, ctx) { // modern browsers
            return Array.prototype.forEach.call(arr, fn, ctx);
        };

		var tooltipReset = function(allowMove, delay) {
                var pointer = this,
                    chart = pointer.chart,
                    hoverSeries = chart.hoverSeries,
                    hoverPoint = chart.hoverPoint,
                    hoverPoints = chart.hoverPoints,
                    tooltip = chart.tooltip,
                    tooltipPoints = tooltip && tooltip.shared ? hoverPoints : hoverPoint;

                // Check if the points have moved outside the plot area (#1003, #4736, #5101)
                if (allowMove && tooltipPoints) {
                    each(splat(tooltipPoints), function(point) {
                        if (point.series.isCartesian && point.plotX === undefined) {
                            allowMove = false;
                        }
                    });
                }

                // Just move the tooltip, #349
                if (allowMove) {
                    if (tooltip && tooltipPoints) {
                        tooltip.refresh(tooltipPoints);
                        if (hoverPoint) { // #2500
                            hoverPoint.setState(hoverPoint.state, true);
                            each(chart.axes, function(axis) {
                                if (axis.crosshair) {
                                    axis.drawCrosshair(null, hoverPoint);
                                }
                            });
                        }
                    }

                    // Full reset
                } else {

                    if (hoverPoint) {
                        hoverPoint.onMouseOut();
                    }

                    if (hoverPoints) {
                        each(hoverPoints, function(point) {
                            point.setState();
                        });
                    }

                    if (hoverSeries) {
                        hoverSeries.onMouseOut();
                    }

                    if (tooltip) {
                        tooltip.hide(delay);
                    }

                    if (pointer.unDocMouseMove) {
                        pointer.unDocMouseMove = pointer.unDocMouseMove();
                    }

                    // Remove crosshairs
                    each(chart.axes, function(axis) {
                        axis.hideCrosshair();
                    });

                    pointer.hoverX = pointer.prevKDPoint = chart.hoverPoints = chart.hoverPoint = null;
                }
            };

	    /**
	     * Synchronize zooming through the setExtremes event handler.
	     */
	    function syncExtremes(e) {
	        var thisChart = this.chart;

	        if (e.trigger !== 'syncExtremes') { // Prevent feedback loop
	            Highcharts.each(Highcharts.charts, function (chart) {
	                if (chart !== thisChart && chart !== undefined && chart.legend !== undefined) {
	                	if (chart.tooltip !== undefined) {
		    				chart.tooltip.hide()
		    			}
	                	if (chart.xAxis[0].cross !== undefined) {
		    				chart.xAxis[0].cross.hide()
		    			}
	                    if (chart.xAxis[0].setExtremes) { // It is null while updating
	                        chart.xAxis[0].setExtremes(e.min, e.max, undefined, false, { trigger: 'syncExtremes' });
	                    }
	                }
	            });
	        }
	    }

		var plot_width = $(window).width() - 75 - $('td#options_block').width();
		if (data.data.series) {
			var yaxis_conf = data.data.yaxis;
			$.each(yaxis_conf, function() {
				var ser = this;
				ser.labels.formatter =
					function() {
						return this.axis.defaultLabelFormatter.call(this) +
								' ' + (ser.label || '') ;
					}
				}
			);
			var cfg={
				chart: {
					reflow: false,
		            renderTo: 'plot_container__' + plotType,
		            height: 330,
		            width: plot_width,
		            zoomType: 'x',
		            animation: false,
		            backgroundColor: '#ffffff',
	            	enabledTracking: true,
	            	resetZoomButton: {
	                    theme: {
	                        fill: 'white',
	                        stroke: 'silver',
	                        r: 0,
	                        states: {
	                            hover: {
	                                fill: '#41739D',
	                                style: {
	                                    color: 'white'
	                                }
	                            }
	                        }
	                    },
	                    relativeTo: 'chart',
	                },
	                style: {
		                fontFamily: 'Yandex Sans Text Web'
		            },
                    events: {
						click: function(event) {
							Highcharts.Pointer.prototype.reset = function () {}; // disable tooltip disappearing
							showAllCrosshairs(event, container);
							var ST = '\
								top: -'+container.height()+'px; \
								height: '+container.height()+'px; \
								margin-bottom: -'+container.height() +'px; \
								z-index: 99; \
								position: relative; \
								background-color: rgba(255,255,255,0);';
							$('.job-plots__highcharts__timeline').each(function() {
								$(this).append('<div class="blocker" style="'+ST+'">\
										<span class="fa fa-lock" style="position: absolute; padding: 5px; color: gray; opacity: 0.3; font-size: 24px;"></span>\
										</div>')
							});
							var $blocker = $('.blocker');
							$blocker.off();
							$blocker.on('click', function(event) {
								Highcharts.Pointer.prototype.reset = tooltipReset; // reenable tooltip disappearing
								hideAllCrosshairs(event);
								$('.blocker').remove();
								event.stopPropagation();
							});
						}
					},
		        },
		        xAxis: {
		            categories: data.data.xaxis,
		            showFirstLabel: true,
		            showLastLabel: true,
		            events: {
                        setExtremes: syncExtremes
                    },
		            labels: {
		            	overflow: 'justify'
		            	},
		        	type: data.x.type,
		    	},
		    	series: data.data.series,
		        yAxis: yaxis_conf,
		        plotOptions: {
		        	area : {
						lineWidth : 0,
						fillOpacity : 1,
					},
					line : {
						lineWidth : 2,
						zIndex : 1,
						states: {hover: {enabled: false}},
						connectNulls: true,
					},
					column : {
						borderWidth: 0,
						states: {hover: {enabled: false}},
					},
					spline : {
						zIndex : 1,
						lineWidth : 2,
						states: {hover: {enabled: false}},
					},
					areaspline : {
						lineWidth : 0,
						fillOpacity : 1,
					},
					arearange: {
						lineWidth : 0,
					},
					series : {
						turboThreshold : 5000,
						animation : false,
						shadow: false,
					},
		        },
		        title: {
		   			text: "",
		   			style: {
		   				fontFamily: '"Yandex Sans Text Web", "Lucida Grande", "Lucida Sans Unicode", Verdana, Arial, Helvetica, sans-serif;',
		   			},
		        },
		        tooltip : {
					animation : false,
					shared : true,
					hideDelay: 10,
					borderRadius : 2,
					borderWidth : 1,
					crosshairs : {
						width : 1,
						color : 'gray',
						dashStyle : 'shortdot',
						zIndex: 3
					},
					style: {
	           			fontSize: '14px',
	           			fontFamily: '"Yandex Sans Text Web", "Lucida Grande", "Lucida Sans Unicode", Verdana, Arial, Helvetica, sans-serif;',
		            },
					useHTML: true,
					formatter: function() {
						var res = '';
						var plotTypes = ["quantiles_vs_times",
						                 "times_dist_percent_plot",
						                 "times_dist_count_plot",
						                 "avgtimes_vs_reqps_plot",
						                 "avgtimes_vs_resps_plot",
						                 "avgtimes_vs_threads_plot"];
						if( $.inArray(plotType, plotTypes) !== -1 ) {
							res += '<b style="text-align: center; font-weight: bold;">' + this.x +' ' + data.data.xaxis_label +'</b><br>'
						}
						res += '<table class="tooltip_table">';
						$.each(this.points, function(i, point) {
							res += '<tr style="padding:0; margin:0;">' +
							'<td style="background-color: rgba(255,255,255,0.2); padding:0 0 0 0.2em; margin:0; text-align: right;">' +
							'<span style="color: ' + this.series.color + ';">' +
							this.series.name.replace(/</g, "&lt;").replace(/>/g, "&gt;") + ': </span></td>' +
							'<td style="width:100%; background-color: rgba(255,255,255,0.2); padding:0 0 0 1em; margin:0; text-align: right;">' +
							'<span style="font-weight: bold; color: ' + this.series.color + ';">' +
							this.y.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "'") + // regexp: thousands delimiter
							'</span></td>' +
							'<td style="width:100%; background-color: rgba(255,255,255,0.2); padding:0 0 0 0.4em; margin:0; text-align: left;">' +
							'<span style="color: ' + this.series.color + ';">' + this.series.options.label +
							'</span></td></tr>';
						});
						res += '</table>';
						return res
					},
				},
				navigator: {
		            enabled: false,
		        },
		        rangeSelector: {
		        	enabled: false,
		        },
		        scrollbar: {
		        	enabled: false,
		        },
		        exporting: {
		            enabled: false,
		        },
		        credits: {
		        	enabled: false,
		        },
				legend : {
					align : 'center',
					verticalAlign : 'bottom',
					itemStyle : {
						color : '#333',
					},
					borderWidth : 0
				},
		};

			MergeRecursive(cfg, data.overrides);
			var chart=new Highcharts.Chart(cfg);

			container.chart = chart;

		    /**
		     * In order to synchronize tooltips and crosshairs, override the
		     * built-in events with handlers defined on the parent element.
		     */

		    function showAllCrosshairs(event) {
		    	var points,
		        i;
		        var ev = container.chart.pointer.normalize(event);
		        var seriesLengths = [];
		        for (j = 0; j < chart.series.length; j++) {
	            	var currentSerie = chart.series[j];
	            	if (currentSerie.visible) {
	            		seriesLengths.push(currentSerie.xIncrement)
	            	}
		        }
		        var longestSerieIndex = seriesLengths.indexOf(Math.max.apply(null, seriesLengths));
		        var point = container.chart.series[longestSerieIndex].searchPoint(ev, true);
		        var x = point.category;
		        for (i = 0; i < Highcharts.charts.length; i++) {
		            chart = Highcharts.charts[i];
		            if (chart !== undefined && chart.pointer !== undefined) {
		            	var e = chart.pointer.normalize(event); // Find coordinates within the chart
			            points = [];
			            for (j = 0; j < chart.series.length; j++) {
			            	currentSerie = chart.series[j];
			            	if (currentSerie.visible) {
			            		pp = chart.series[j].data.filter(function( p ) {
			            			  return p.category === x;
			            			}
			            		);
			            		if (pp[0] !== undefined) {
			            			points.push(pp[0]);
			            		}
			            	}
			            }
		                if (points.length) {
		                    chart.tooltip.refresh(points); // Show the tooltip
		                    chart.xAxis[0].drawCrosshair(e, points[0]); // Show the crosshair
		                }
		            }
		        }
            }
            function hideAllCrosshairs(event) {
		    	for (var i = 0; i < Highcharts.charts.length; i++) {
		    		chart = Highcharts.charts[i];
		    		if (chart !== undefined) {
		    			chart.options.chart.enabledTracking = true;
		    			if (chart.tooltip !== undefined) {
		    				chart.tooltip.hide()
		    			}
		    			if (chart.xAxis[0].cross !== undefined) {
		    				chart.xAxis[0].cross.hide()
		    			}
		    		}
		    	}
            }
            container.addClass('highcharts-plot');
		    container.unbind();
		    container.bind('click', function(event) {
		        var ch;
		    	if (chart.options.chart.enabledTracking === true) {
		    		showAllCrosshairs(event);
		    		var ST = '\
		    			top: -'+container.height()+'px; \
		    			height: '+container.height()+'px; \
		    			width: '+container.width()+'px; \
		    			margin-bottom: -'+ container.height() +'px; \
		    			z-index: 99; \
		    			position: relative; \
		    			background-color: rgba(255,255,255,0);';
		    		for (i = 0; i < Highcharts.charts.length; i++) {
			            ch = Highcharts.charts[i];
			            if (ch !== undefined) {
			            	ch.options.chart.enabledTracking = false; // disableTracking
			            }
		    		}
		    		$('.highcharts-plot').each(function() {
		    			$(this).append('<div class="blocker" style="'+ST+'">\
		    					<span class="fa fa-lock" style="position: absolute; padding: 5px; color: gray; opacity: 0.3; font-size: 24px;"></span>\
		    					</div>')
		    		})
		    	}
		    	else {
		    		hideAllCrosshairs(event);
		    		$('.blocker').remove();
		    		for (i = 0; i < Highcharts.charts.length; i++) {
			            ch = Highcharts.charts[i];
			            if (ch !== undefined) {
			            	ch.options.chart.enabledTracking = true; // enableTracking
			            }
		    		}
		    	}
		    });
		}
		else {
			$('div#compress_ratio__' + plotType).hide();
			var cont = $('div#plot_container__' + plotType);
			cont.css({"width":plot_width, "height": "330px", "align":"center",});
			cont.append('<div style="padding-top: 3em; text-align: center; color: #3E576F; font-size: 300%;">Нет Данных</div>')
		}
		$(window).resize(function() {
		    var height = 330;
		    var width = $(window).width() - 75 - $('td#options_block').width();
		    chart.setSize(width, height, doAnimation = false);
		});
	}

	function MergeRecursive(obj1, obj2) {
		for (var p in obj2) {
			try {
				// Property in destination object set; update its value.
				if ( obj2[p].constructor===Object ) {
					obj1[p] = MergeRecursive(obj1[p], obj2[p]);
				} else {
					obj1[p] = obj2[p];
				}
			} catch(e) {
		      // Property in destination object not set; create it and set its value.
		      obj1[p] = obj2[p];
			}
		}
		return obj1;
	}

	function getObjects(obj, key, val) {
	    var objects = [];
	    for (var i in obj) {
	        if (!obj.hasOwnProperty(i)) continue;
	        if (typeof obj[i] === 'object') {
	            objects = objects.concat(getObjects(obj[i], key, val));
	        } else if (i === key && obj[key] === val) {
	            objects.push(obj);
	        }
	    }
	    return objects;
	}

	function getUrlVars (str) {
        var vars = {};
	    if (str === undefined) {
	        str = window.location.href.replace('#','&')
	    }
	    str = str.replace(/</g, "&lt;").replace(/>/g, "&gt;");
	    str.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
            vars[key] = value;
	    });
	    return vars;
	}
})();
