(function() {

	'use strict';

	// Set the help messages for choosing of tank and set

	const common_help_message = 'Выбран общественный железный танк. Подходит для целей на выделенных серверах. Будет выбран танк из датацентра мишени.<br>\
	                            Потребуется <a href="https://wiki.yandex-team.ru/Load/howto/idm-puncher/">доступ</a> от _TANKNETS_ до вашего стенда. \
								Подробнее про <a href="https://wiki.yandex-team.ru/Load/howto/TankHowTo/">выбор танка</a>';

	const host_help_message =   'Выбран танк по строго определенному адресу. Танк должен размещаться в датацентре мишени и не сможет стрелять в балансер.<br>\
	                            Потребуется <a href="https://wiki.yandex-team.ru/Load/howto/idm-puncher/">доступ</a> от _LOAD_PROD_NETS_ и _CMSEARCHNETS_ до Вашего танка на порт, на котором запущен процесс tankapi (по умолчанию 8083) и от Вашего танка до slb-lunapark.yandex-team.ru:443. \
							    Подробнее про <a href="https://wiki.yandex-team.ru/Load/howto/TankHowTo/">выбор танка</a>';

	const nanny_help_message = 'Выбран танк как сервис в RTC. Подходит для сервисов в облачной инфраструктуре.<br>\
	                            Для сервиса production_yandex_tank потребуется <a href="https://wiki.yandex-team.ru/Load/howto/idm-puncher/">доступ</a> от _GENCFG_ALL_RCLOUD_TANKS_ до вашего стенда, \
								в случае собственного сервиса - доступ от _LOAD_PROD_NETS_ и _CMSEARCHNETS_ до Ваших танков на порт, на котором запущен процесс tankapi (по умолчанию 8083) и от Ваших танков до slb-lunapark.yandex-team.ru:443. \
							    Поробнее про <a href="https://wiki.yandex-team.ru/Load/howto/TankHowTo/">выбор танка</a>';

	const sandbox_help_message = 'Выбран танк как Sandbox задача. Необходимо дополнительно указать пользователя или группу, в чьей квоте будет запущена задача, секрет с sandbox_oauth_token и наименование ключа, если оно отличается от стандартного.<br>\
	                            Потребуется <a href="https://wiki.yandex-team.ru/Load/howto/idm-puncher/">доступ</a> от _CMSEARCHNETS_ до Вашего стенда. \
							    Подробнее про <a href="https://wiki.yandex-team.ru/Load/howto/TankHowTo/">выбор танка</a>';

	let tank_host = '';
	if (document.location.pathname == '/firestarter/') {
		let value = 'nanny';
		const urlParams = new URLSearchParams(document.location.search);
		if (urlParams.has('use_tank')) {
				value = 'host';
				tank_host = urlParams.get('use_tank');
				set_tank_host();
		} else {
				set_tank_nanny();
		}

		Array.from(document.getElementsByTagName('input')).forEach(function(button){
			if (button.getAttribute('value') == value){
				button.checked = true;
			}
		});
	}

	// this part is essential, because apparently js yaml dumper is more strict than pythonic
    // Otherwise some strings with spaces might end up unquoted
	var editor = ace.edit('editorYaml');
	var yamlConfig = YAML.parse(editor.getValue());
	editor.setValue(YAML.stringify(yamlConfig));
	editor.session.selection.clearSelection();

	// set values from inputs into editor
	function set_param (param, value) {

		var editor = ace.edit('editorYaml');
		var yamlConfig = YAML.parse(editor.getValue());

		switch(param) {
		    case 'ammofile':
                if (!yamlConfig.hasOwnProperty('phantom')) {
                    yamlConfig.phantom = {};
                }
                yamlConfig.phantom.ammofile = value;
                break;
			case 'pandora_binary':
                if (!yamlConfig.hasOwnProperty('pandora')) {
                    yamlConfig.pandora = {};
                }
                yamlConfig.pandora.pandora_cmd = value;
                break;
            case 'address':
                if (!yamlConfig.hasOwnProperty('phantom')) {
                    yamlConfig.phantom = {};
                }
                yamlConfig.phantom.address = value;
                break;
            case 'uris':
                if (!yamlConfig.hasOwnProperty('phantom')) {
                    yamlConfig.phantom = {};
                }
                if (value === '') {
                	yamlConfig.phantom.uris = [];
				} else {
                	yamlConfig.phantom.uris = value.split(/[ \t\n]/);
				}
                break;
            case 'rps_schedule':
                if (!yamlConfig.hasOwnProperty('phantom')) {
                    yamlConfig.phantom = {load_profile: {load_type: 'rps', schedule: value}};
                } else if (!yamlConfig.phantom.hasOwnProperty('load_profile')) {
                    yamlConfig.phantom.load_profile = {load_type: 'rps', schedule: value}
                } else {
                    yamlConfig.phantom.load_profile.schedule = value
                }
                break;
            case 'instances_schedule':
                if (!yamlConfig.hasOwnProperty('phantom')) {
                    yamlConfig.phantom = {load_profile: {load_type: 'instances', schedule: value}};
                } else if (!yamlConfig.phantom.hasOwnProperty('load_profile')) {
                    yamlConfig.phantom.load_profile = {load_type: 'instances', schedule: value}
                } else {
                    yamlConfig.phantom.load_profile.schedule = value
                }
                break;
            case 'job_name':
                if (!yamlConfig.hasOwnProperty('uploader')) {
                    yamlConfig.uploader = {};
                }
                yamlConfig.uploader.job_name = value;
                break;
            case 'job_dsc':
                if (!yamlConfig.hasOwnProperty('uploader')) {
                    yamlConfig.uploader = {};
                }
                yamlConfig.uploader.job_dsc = value;
                break;
            case 'ver':
                if (!yamlConfig.hasOwnProperty('uploader')) {
                    yamlConfig.uploader = {};
                }
                yamlConfig.uploader.ver = value;
                break;
            case 'task':
                value = value.replace(/https?:\/\/st.yandex-team.ru\//, '');  // превращаем ссылку на трекер в key таска
                if (!yamlConfig.hasOwnProperty('uploader')) {
                    yamlConfig.uploader = {};
                }
                yamlConfig.uploader.task = value;
                break;
			case 'use_tank':
                if (!yamlConfig.hasOwnProperty('metaconf')) {
                    yamlConfig.metaconf = {package: 'yandextank.plugins.MetaConf', firestarter: {}};
                } else if (!yamlConfig.metaconf.hasOwnProperty('firestarter')) {
                    yamlConfig.metaconf.firestarter = {};
                }
				yamlConfig.metaconf.enabled = true
                yamlConfig.metaconf.firestarter.tank = value;
                break;
			case 'owner':
				if (!yamlConfig.hasOwnProperty('metaconf') || !yamlConfig.metaconf.hasOwnProperty('firestarter')) {
					yamlConfig.metaconf = {package: 'yandextank.plugins.MetaConf', firestarter: {}};
				}
				yamlConfig.metaconf.firestarter.owner = value;
				break;
			case 'secret':
				if (!yamlConfig.hasOwnProperty('metaconf') || !yamlConfig.metaconf.hasOwnProperty('firestarter')) {
					yamlConfig.metaconf = {package: 'yandextank.plugins.MetaConf', firestarter: {}};
				}
				yamlConfig.metaconf.firestarter.secret = value;
				break;
			case 'key':
				if (!yamlConfig.hasOwnProperty('metaconf') || !yamlConfig.metaconf.hasOwnProperty('firestarter')) {
					yamlConfig.metaconf = {package: 'yandextank.plugins.MetaConf', firestarter: {}};
				}
				yamlConfig.metaconf.firestarter.key = value;
				break;
			case 'clear_metaconf':
				if (yamlConfig.hasOwnProperty('metaconf')) {
					yamlConfig.metaconf.firestarter = {};
				} else {
					yamlConfig.metaconf = {package: 'yandextank.plugins.MetaConf', firestarter: {}};
				}
				break;
        }

        editor.setValue(YAML.stringify(yamlConfig));
        editor.session.selection.clearSelection();

	}

	function testForEnter(event)
	{
		if (event.key === "Enter") {
			$("#firestarter-submit").click()
		}
	}

    $('input.form-control').on('input', function(event) {
    	if (!$(this).hasClass('no_set_param')) {
    		$(this).removeClass('firestarter-input__invalid');
			set_param($(this).data('type'), this.value);
		}
	});

	$('input.form-control').on('keypress', function(event) {
		if (!$(this).hasClass('no_set_param')) {
            testForEnter(event);
        }
	});

	$('input.firestarter-input__task').blur(function (event) {
       getProjectAmmo(this.value);
       getProjectPandoraBinary(this.value)
    });

	$('select.firestarter-input__ammo').on('change', function() {
        set_param($(this).data('type'), this.value);
    });

	$('select.firestarter-input__pandora_binary').on('change', function() {
        set_param($(this).data('type'), this.value);
    });


    // Кнопка "Огонь!"

    $("button#firestarter-submit").click(function() {
    	var waiterBody = $('#waiter_body');
        $('html, body').animate({ scrollTop: 0 }, 'fast');
        var errorBlock = $('#error_block');
        $('#tank').text('');
		$('#port').text('');
		$('#status').text('');
		$('#link').data('link', '');
        waiterBody.removeClass('alert-danger');
        waiterBody.removeClass('alert-info');
        waiterBody.removeClass('alert-success');
		waiterBody.addClass('alert-warning');
    	errorBlock.hide();
    	waiterBody.show();
    	$(this).prop('disabled', true);
    	var editorYaml = ace.edit("editorYaml");
    	var editorXML = ace.edit("editorXML");

    	$.post('/firestarter/fire', {
    	    'conf': editorYaml.session.getValue(),
            'monitoring_conf': editorXML.session.getValue()
    	}, function(response) {
	    	if (response['success']) {
	    		renderWaiter(response);
	    		wait(response);
	    		window.scrollTo(0, 0);
	    	}
	    	else {
	    		showError(response['error'], response['error_link'])
	    	}
	    }, 'json');

    	function showError(error_text, error_link) {
    		$('#error_text').text(error_text);
    		if (error_link) {
    			$('#error_text').append('<br><a id="error_link" target="_blank" href="'+error_link+'">Ссылка</a>')
    		}
    		$('#error_block').show();
    		$("button#firestarter-submit").prop('disabled', false)
    	}

    	function renderWaiter(response) {
    		if (response['tank_msg']) {
    			showError(response['tank_msg'], null);
    			return
    		}
    		$('#tank').text(response['tank']);
    		$('#port').text(response['port']);
    		$('#status').text(response['status']);
    		$('#link').data('link', response['link']);
    		$('#waiter_body').show()
    	}

    	function wait(response) {
    		var waiterBody = $('#waiter_body');
			switch (response['status']) {
		    case 'sandbox_started':
		        waiterBody.removeClass('alert-danger');
				waiterBody.addClass('alert-warning');
				setTimeout(function() {
					$.get('/firestarter/waiter_refresh?tank='+response['tank']+'&port='+response['port']+'&id='+response['id'], function(response) {
						renderWaiter(response);
						wait(response)
					}, 'json')
				}, 5000);
				break;
			case 'queued':
				waiterBody.removeClass('alert-warning');
				waiterBody.addClass('alert-info');
				setTimeout(function() {
					$.get('/firestarter/waiter_refresh?tank='+response['tank']+'&port='+response['port']+'&id='+response['id']+'&location=local', function(response) {
						renderWaiter(response);
						wait(response)
					}, 'json')
				}, 5000);
				break;
			//NOT_FOUND|PREPARING|RUNNING|FINISHING|FINISHED
			case 'FINISHING':
				setTimeout(function() {
					$.get('/firestarter/waiter_refresh?tank='+response['tank']+'&port='+response['port']+'&id='+response['id'], function(response) {
						renderWaiter(response);
						wait(response)
					}, 'json')
				}, 5000);
				break;
			case 'PREPARING':
				waiterBody.removeClass('alert-danger');
				waiterBody.addClass('alert-warning');
				setTimeout(function() {
					$.get('/firestarter/waiter_refresh?tank='+response['tank']+'&port='+response['port']+'&id='+response['id'], function(response) {
						renderWaiter(response);
						wait(response)
					}, 'json')
				}, 5000);
				break;
            case 'IN_PROGRESS':
                waiterBody.removeClass('alert-danger');
				waiterBody.addClass('alert-warning');
				setTimeout(function() {
					$.get('/firestarter/waiter_refresh?link='+response['link'], function(response) {
						renderWaiter(response);
						wait(response)
					}, 'json')
				}, 5000);
				break;
			case 'INITIATED':
				waiterBody.removeClass('alert-danger');
				waiterBody.addClass('alert-warning');
				setTimeout(function() {
					$.get('/firestarter/waiter_refresh?tank='+response['tank']+'&port='+response['port']+'&id='+response['id'], function(response) {
						renderWaiter(response);
						wait(response)
					}, 'json')
				}, 5000);
				break;
			case 'RUNNING':
				waiterBody.removeClass('alert-danger');
				waiterBody.removeClass('alert-warning');
				waiterBody.addClass('alert-success');
				setTimeout(function() {
					window.location = $("#link").data("link");
				}, 2000);
				break;
			case 'FINISHED':
				waiterBody.removeClass('alert-danger');
				waiterBody.removeClass('alert-warning');
				waiterBody.addClass('alert-success');
				if (!response["tank_msg"]) {
				    setTimeout(function() {
                        window.location = $("#link").data("link");
                    }, 2000);
                }
				break;
			default:
				waiterBody.removeClass('alert-warning');
				waiterBody.addClass('alert-danger');
				$('#firestarter-submit').prop('disabled', false);
				$(".krutilka").hide();
				break
			}
		}
    });


	// Саджесты тасков

	$(".firestarter-suggest__task").bind('click',
        function(event) {
            var task_input_field = $("input.firestarter-input__task");
            task_input_field.val($(this).text());
            set_param('task', $(this).text());
        });


	// Саджесты мишеней

	$(".firestarter-suggest__target").bind('click',
        function(event){
            var target_input_field = $("input.firestarter-input__target");
            target_input_field.val($(this).text());
            set_param('address', $(this).text());
        });


	// Саджесты танков

	$(".firestarter-suggest__tank").bind('click',
        function(event){
            var tank_input_field = $("input.firestarter-input__tank");
            tank_input_field.val($(this).text());
            set_param('use_tank', $(this).text());
        });


	// Саджест схемы нагрузки

	$(".firestarter-suggest__loadscheme").bind('click',
        function(event){
	        var editor = ace.edit('editorYaml');
		    var yamlConfig = YAML.parse(editor.getValue());
		    var loadchemeInput = $("input.firestarter-input__loadscheme");
		    loadchemeInput.val(loadchemeInput.val() + ' ' + $(this).text());
		    if (!yamlConfig.hasOwnProperty('phantom')) {
                yamlConfig.phantom = {load_profile: {load_type: 'rps', schedule: $(this).text()}};
            } else if (!yamlConfig.phantom.hasOwnProperty('load_profile')) {
                yamlConfig.phantom.load_profile = {load_type: 'rps', schedule: $(this).text()}
            } else {
                yamlConfig.phantom.load_profile.schedule += ' ' + $(this).text()
            }
            editor.setValue(YAML.stringify(yamlConfig));
            editor.session.selection.clearSelection();
    	});


	// Кнопка загрузки патронов

	$('#uploadAmmoForm').submit(function () {
		var formData = new FormData($(this)[0]);
		$('#upload_ammo_submit').prop('disabled', true);
		$('#ammoKrutilka').show();
		$.ajax({
			url: "/firestarter/upload_ammo",
			type: 'POST',
			data: formData,
			async: true,
			dataType : 'json',
			success: function (data) {
				if (data['success'] === true) {
					$('#upload_ammo_cancel').click();
					var $ammoSelect = $('#ammo_select');
					$ammoSelect.prepend('<option value="'+data['path']+'" style="font-weight: bold;">'+data['dsc']+'</option>');
                    $('select[name=ammo_select]').val(1);
                    $ammoSelect.selectpicker('refresh');
                    // UPDATE EDITOR
                    set_param('ammofile', data['path']);
				} else {
					alert(data['error'])
				}
			},
			complete: function() {
				$('#upload_ammo_submit').prop('disabled', false);
				$('#ammoKrutilka').hide();
			},
			cache: false,
			contentType: false,
			processData: false
		});
		return false;
	});


    // Проектные патроны

    function getProjectAmmo(task)
    {
        var ammoSelect = $( "#ammo_select" );
    	$(".krutilka").show();
    	ammoSelect.prop( "disabled", true );

    	$.get('/firestarter/project_ammo?task=' + task, function(data){
    		$("option").remove(".project_ammo");
    		if (data) {
    			$("input#task_input").css('background-color', '#FFFFFF');
    			if (data.length > 0) {
    				$("#ammo_select").append("<option class='project_ammo' value='' id='separator' disabled='disabled'>Проектные патроны</option>")
    			}
    			$("#separator").css('font-weight', 'bold');
    			for (var i =0; i<data.length; i++) {
    				$("#ammo_select").append("<option class='project_ammo' value="+data[i][0]+">"+data[i][1]+"</option>")
    			}
    		}
    		else {
    			$("input#task_input").css('background-color', '#FFD5C7')
    		}
    		$(".krutilka").hide();
    		ammoSelect.prop( "disabled", false );
    		$('.selectpicker').selectpicker('refresh');
    	})
    }


	// При повторении стрельбы сразу подгружать проектные патроны

	var task = $('input.firestarter-input__task').val();
	if (task) {
		getProjectAmmo(task)
	}

	
    // Кнопка загрузки пандорских бинарей

	$('#uploadPandoraBinaryForm').submit(function () {
		var formData = new FormData($(this)[0]);
		$('#upload_pandora_binary_submit').prop('disabled', true);
		$('#pandoraBinaryKrutilka').show();
		$.ajax({
			url: "/firestarter/upload_pandora_binary",
			type: 'POST',
			data: formData,
			async: true,
			dataType : 'json',
			success: function (data) {
				if (data['success'] === true) {
					$('#upload_pandora_binary_cancel').click();
					var $pandoraBinarySelect = $('#pandora_binary_select');
					$pandoraBinarySelect.prepend('<option value="'+data['path']+'" style="font-weight: bold;">'+data['dsc']+'</option>');
                    $('select[name=pandora_binary_select]').val(1);
                    $pandoraBinarySelect.selectpicker('refresh');
                    // UPDATE EDITOR
                    set_param('pandora_binary', data['path']);
				} else {
					alert(data['error'])
				}
			},
			complete: function() {
				$('#upload_pandora_binary_submit').prop('disabled', false);
				$('#pandoraBinaryKrutilka').hide();
			},
			cache: false,
			contentType: false,
			processData: false
		});
		return false;
	});


    // Проектные бинари

    function getProjectPandoraBinary(task)
    {
        var pandoraBinarySelect = $( "#pandora_binary_select" );
    	$(".krutilka").show();
    	pandoraBinarySelect.prop( "disabled", true );

    	$.get('/firestarter/project_pandora_binaries?task=' + task, function(data){
    		$("option").remove(".project_pandora_binary");
    		if (data) {
    			$("input#task_input").css('background-color', '#FFFFFF');
    			if (data.length > 0) {
    				$("#pandora_binary_select").append("<option class='project_pandora_binary' value='' id='separator' disabled='disabled'>Проектные пушки</option>")
    			}
    			$("#separator").css('font-weight', 'bold');
    			for (var i =0; i<data.length; i++) {
    				$("#pandora_binary_select").append("<option class='project_pandora_binary' value="+data[i][0]+">"+data[i][1]+"</option>")
    			}
    		}
    		else {
    			$("input#task_input").css('background-color', '#FFD5C7')
    		}
    		$(".krutilka").hide();
    		pandoraBinarySelect.prop( "disabled", false );
    		$('.selectpicker').selectpicker('refresh');
    	})
    }


	// Выбор танка и настройка его параметров

	let tank_form = document.getElementById('tank_type_select');
    let radios = tank_form.querySelectorAll('input[type="radio"]');

	tank_form.onclick = function() {
		set_param('clear_metaconf', '');
		Array.from(document.getElementsByClassName('tank_params')).forEach(function(div){
		    div.setAttribute('style', "display:none;");
		    Array.from(div.getElementsByTagName('input')).forEach(function(input){
			    input.value = "";
		    })
		})

		for (let t=0; t<radios.length; t++) {
			if (radios[t].checked) {
				switch(radios[t].value){
				case 'host':
					set_tank_host();
					break;
				case 'nanny':
					set_tank_nanny();
					break;
				case 'sandbox':
					set_tank_sandbox();
					break;
				case 'common':
					set_tank_common();
					break;
				}
			}
		}
	}

	function set_tank_host () {
		Array.from(document.getElementsByClassName('tank_value')).forEach(function(div){
			div.setAttribute('style', "display:line;");
			div.getElementsByTagName('span')[0].innerHTML = "Адрес";
		})
		document.querySelector('[name="tank_input"]').placeholder = "Tank address";
		document.querySelector('[name="tank_input"]').value = tank_host;
		document.getElementById('tank_help_message').innerHTML = host_help_message;
	}

	function set_tank_nanny () {
		Array.from(document.getElementsByClassName('tank_value')).forEach(function(div){
			div.setAttribute('style', "display:line;");
			div.getElementsByTagName('span')[0].innerHTML = "Сервис";
		})
		document.querySelector('[name="tank_input"]').placeholder = "Service name";
		document.querySelector('[name="tank_input"]').value = "nanny:production_yandex_tank";
		set_param('use_tank', 'nanny:production_yandex_tank');
		document.getElementById('tank_help_message').innerHTML = nanny_help_message;
	}

	function set_tank_sandbox () {
		Array.from(document.getElementsByClassName('sandbox_params')).forEach(function(div){
			div.setAttribute('style', "display:line;");
		})
		set_param('use_tank', 'sandbox');
		document.getElementById('tank_help_message').innerHTML = sandbox_help_message;
    }

	function set_tank_common () {
		set_param('use_tank', 'common');
		document.getElementById('tank_help_message').innerHTML = common_help_message;
	}

})();
