(function() {
	'use strict';
	
	$('.ammo__action').on('click', function (event) {
		var button = $(this);
		var action = button.data('action');

		switch (action) {
			case 'star':
				$.post('/mainpage/ammo/action', {
					ammo_id : button.data('ammo'),
					action : 'flag'
				}).success(function() {
					button.toggleClass('text-warning');
					button.toggleClass('text-muted');
				});
				break;
			case 'visibility':
				$.post('/mainpage/ammo/action', {
					ammo_id : button.data('ammo'),
					action : 'hidden'
				}).success(function() {
					button.toggleClass('text-success');
					button.toggleClass('text-danger');
					button.toggleClass('fa-eye-slash');
					button.toggleClass('fa-eye');
				});
				break;
			case 'share':
				var sharedWithUrl = '/mainpage/ammo/shared_with?path='+button.data('ammopath');
				$.get(sharedWithUrl).success(function(people) {
					var p_len = people.length;
					if (p_len) {
						$('#shared-block__'+button.data('ammo')).html(
								'<br> \
						        <span>доступ уже есть у:</span> \
						        <ul id="people__'+button.data('ammo')+'"> \
						        </ul>'
								);
						var peopleListObj = $('#people__'+button.data('ammo'));
						for (var i=0; i<p_len; i++) {
							peopleListObj.append('<li class="person">'+people[i]+',&nbsp;</li>')
						}
					}
				});
			case 'private':
				$.post('/mainpage/ammo/action', {
					ammo_id : button.data('ammo'),
					action : 'private'
				}).success(function() {
					button.toggleClass('text-success');
					button.toggleClass('text-danger');
					button.toggleClass('fa-unlock');
					button.toggleClass('fa-lock');
				});
				break;
			default:
				break;
		}
	});
	
	
	$(".ammoShareSubmit").on('click', function(event){
		var ammo_id=$(this).data('ammo');
		$.post('/mainpage/ammo/share', {
			ammo_id : ammo_id,
			persons : $("#ammoSharePerson__"+ammo_id).val()
		}).success(function() {
			$("#ammoShareDismiss__"+ammo_id).click()
		});
	});
	
	
	/*
	 * Редактирование описания
	 */
	
	$('.ammo_dsc.b-editable').on('mouseenter', function(event) {
		var ammo = $(this).data('ammo');
		$('#ammo_dsc_pencil__'+ammo).show()
	});
	
	$('.ammo_dsc.b-editable').on('mouseleave', function(event) {
		var ammo = $(this).data('ammo');
		$('#ammo_dsc_pencil__'+ammo).hide()
	});
	
	$('.ammo_dsc.b-editable').on('click', function(event) {
		var ammo = $(this).data('ammo');
		$(this).hide();
		$('#ammo_dsc_edit__'+ammo).show();
		$('#ammo_dsc_text__'+ammo).val($('.ammo_dsc.b-editable[data-ammo="'+ammo+'"]').text());
		$('#ammo_dsc_text__'+ammo).focus();

		$('#ammo_dsc_edit__okey__'+ammo).show();
		$('#ammo_dsc_edit__cancel__'+ammo).show();
	});

	$('.ammo_dsc_edit__cancel').on('click', function(event) {
		var ammo = $(this).data('ammo');
		$('#ammo_dsc_edit__'+ammo).hide();
		$('.b-editable[data-ammo="'+ammo+'"]').show();
	});

	$('.ammo_dsc_edit__okey').on('click', function(event) {
		var ammo = $(this).data('ammo');
		var text = $("#ammo_dsc_text__"+ammo).val();

		$("#ammo_dsc_edit__okey__"+ammo).hide();
		$("#ammo_dsc_edit__cancel__"+ammo).hide();
		
		$.post('/mainpage/ammo/edit_dsc', {
			ammo_id : $(this).data('ammo'),
			description : text
		}).success(function() {
			$('.ammo_dsc.b-editable[data-ammo="'+ammo+'"]').text(text);
			$('#ammo_dsc_edit__'+ammo).hide();
			$('.ammo_dsc.b-editable[data-ammo="'+ammo+'"]').show();
		});
	});
	
})();