(function() {
	'use strict';
	
	$('.pandora_binary__action').on('click', function (event) {
		var button = $(this);
		var action = button.data('action');

		switch (action) {
			case 'star':
				$.post('/mainpage/pandora_binary/action', {
					pandora_binary_id : button.data('pandora_binary'),
					action : 'flag'
				}).success(function() {
					button.toggleClass('text-warning');
					button.toggleClass('text-muted');
				});
				break;
			case 'visibility':
				$.post('/mainpage/pandora_binary/action', {
					pandora_binary_id : button.data('pandora_binary'),
					action : 'hidden'
				}).success(function() {
					button.toggleClass('text-success');
					button.toggleClass('text-danger');
					button.toggleClass('fa-eye-slash');
					button.toggleClass('fa-eye');
				});
				break;
			case 'share':
				var sharedWithUrl = '/mainpage/pandora_binary/shared_with?path='+button.data('pandora_binarypath');
				$.get(sharedWithUrl).success(function(people) {
					var p_len = people.length;
					if (p_len) {
						$('#shared-block__'+button.data('pandora_binary')).html(
								'<br> \
						        <span>доступ уже есть у:</span> \
						        <ul id="people__'+button.data('pandora_binary')+'"> \
						        </ul>'
								);
						var peopleListObj = $('#people__'+button.data('pandora_binary'));
						for (var i=0; i<p_len; i++) {
							peopleListObj.append('<li class="person">'+people[i]+',&nbsp;</li>')
						}
					}
				});
			case 'private':
				$.post('/mainpage/pandora_binary/action', {
					pandora_binary_id : button.data('pandora_binary'),
					action : 'private'
				}).success(function() {
					button.toggleClass('text-success');
					button.toggleClass('text-danger');
					button.toggleClass('fa-unlock');
					button.toggleClass('fa-lock');
				});
				break;
			default:
				break;
		}
	});
	
	
	$(".pandoraBinaryShareSubmit").on('click', function(event){
		var pandora_binary_id=$(this).data('pandora_binary');
		$.post('/mainpage/pandora_binary/share', {
			pandora_binary_id : pandora_binary_id,
			persons : $("#pandoraBinarySharePerson__"+pandora_binary_id).val()
		}).success(function() {
			$("#pandoraBinaryShareDismiss__"+pandora_binary_id).click()
		});
	});
	
	
	/*
	 * Редактирование описания
	 */
	
	$('.pandora_binary_dsc.b-editable').on('mouseenter', function(event) {
		var pandora_binary = $(this).data('pandora_binary');
		$('#pandora_binary_dsc_pencil__'+pandora_binary).show()
	});
	
	$('.pandora_binary_dsc.b-editable').on('mouseleave', function(event) {
		var pandora_binary = $(this).data('pandora_binary');
		$('#pandora_binary_dsc_pencil__'+pandora_binary).hide()
	});
	
	$('.pandora_binary_dsc.b-editable').on('click', function(event) {
		var pandora_binary = $(this).data('pandora_binary');
		$(this).hide();
		$('#pandora_binary_dsc_edit__'+pandora_binary).show();
		$('#pandora_binary_dsc_text__'+pandora_binary).val($('.pandora_binary_dsc.b-editable[data-pandora_binary="'+pandora_binary+'"]').text());
		$('#pandora_binary_dsc_text__'+pandora_binary).focus();

		$('#pandora_binary_dsc_edit__okey__'+pandora_binary).show();
		$('#pandora_binary_dsc_edit__cancel__'+pandora_binary).show();
	});

	$('.pandora_binary_dsc_edit__cancel').on('click', function(event) {
		var pandora_binary = $(this).data('pandora_binary');
		$('#pandora_binary_dsc_edit__'+pandora_binary).hide();
		$('.b-editable[data-pandora_binary="'+pandora_binary+'"]').show();
	});

	$('.pandora_binary_dsc_edit__okey').on('click', function(event) {
		var pandora_binary = $(this).data('pandora_binary');
		var text = $("#pandora_binary_dsc_text__"+pandora_binary).val();

		$("#pandora_binary_dsc_edit__okey__"+pandora_binary).hide();
		$("#pandora_binary_dsc_edit__cancel__"+pandora_binary).hide();
		
		$.post('/mainpage/pandora_binary/edit_dsc', {
			pandora_binary_id : $(this).data('pandora_binary'),
			description : text
		}).success(function() {
			$('.pandora_binary_dsc.b-editable[data-pandora_binary="'+pandora_binary+'"]').text(text);
			$('#pandora_binary_dsc_edit__'+pandora_binary).hide();
			$('.pandora_binary_dsc.b-editable[data-pandora_binary="'+pandora_binary+'"]').show();
		});
	});
	
})();