(function (){
	'use strict';
	
	var job = $('#global-job-number').data('job');
	
	$('.b-editable').bind('mouseenter', function() {
		$('span#'+this.id+'_pencil').show();
	});
	$('.b-editable').bind('mouseleave', function() {
		$('span#'+this.id+'_pencil').hide();
	});
	
	$('#submitThank').bind('click', function(){
		$(this).prop('disabled', true);
		$('#thKrutilka').show();
		$.ajax({
		      url: $('#thankForm').attr('action'),
		      type: 'post',
		      data : $('#thankForm').serialize(),
		      async: false, 
		      success: function(data){
		    	  $('#thKrutilka').hide();
		    	  if (data.success) {
		    		  $.when(
	      				$("#success").animate({ opacity: 1 }, 1000).promise()
	  		    	  ).done(function(){
	      				$('#thankModal').modal('hide');
	      				$("#success").css('opacity', 0);
	      				$('#submitThank').prop('disabled', false);
	  		    	  });
		    	  }
		    	  else {
		    		  $.when(
	      				$("#fail").animate({ opacity: 1 }, 1000).promise()
	  		    	  ).done(function(){
	      				$('#thankModal').modal('hide');
	      				$("#fail").css('opacity', 0);
	      				$('#submitThank').prop('disabled', false);
	  		    	  });
		    	  }
		      },
		}, 'json');
	});
	
	$('.b-lunapark-offlinepage__action').on('click', function () {
		var button = $(this);
		var action = button.data('action');
		$("#controls_krutilka").show();
		switch (action) {
			case 'remove':
				if (!confirm("Таки удалить эту стрельбу или нет?")) {
					return false;
				}

				$.post('/mass_delete.json', {
					"type": "mobile",
					"fire_ids[]" : job
				}).success(function(data) {
					if (data.status === 1) {
						window.location.href = "/" + button.data("task") + "#mobile";
					}
				});
				break;
			case 'compare':
				var action = button.data('actiondetail');
				$.post('/mass_compare.json', {
					"type": "mobile",
					"action" : action,
					"fire_ids[]" : job
				}).success(function(data) {
					if (action === 'add') {
						button.data('actiondetail', 'remove')
					}
					else {
						button.data('actiondetail', 'add')
					}
					button.toggleClass('text-muted');
					button.toggleClass('text-success');
					if (data) {
						if (data.status === 1) {
							$(".b_mobilecompare_count").html(data.count);
							if (data.count > 0) {
								$(".b_mobilecompare_count__delete").show();
							} else {
								$(".b_mobilecompare_count__delete").hide();
							}
						}
					}

				});
				break;
			case 'edit':
				window.location.href = "/mobile/" + job + "/edit";
				break;
			case 'star':
				// the star
				var isFav = button.hasClass('text-warning');
				$.ajax('/' + button.data('task') + '/addtofav.json', {
					type : 'POST',
					dataType : 'json',
					data : {
						type: "mobile",
						action : isFav ? 'remove' : 'add',
						job_id : job
					},
				}).success(function(data) {
					if (data.status === 1) {
						button.toggleClass('text-muted');
						button.toggleClass('text-warning');
					}
				});
				break;
			default:
				break;
		}
		$("#controls_krutilka").hide();
	});
	
	
	/*
	 * При клике на редактирование имени стрельбы
	 */
	$('.b-lunapark-offline-meta__title').on('click', function() {
		$('.b-editable[data-action="edit-name"]').hide();
		$('.b_editname_block').show();
		$("#b_editname_block__firename__").val($('.b-editable[data-action="edit-name"]').text());
		$("#b_editname_block__firename__").focus();

		$("#b_editname_block__okey__").show();
		$("#b_editname_block__cancel__").show();
		$("#b_editname_block__ajax__").hide();
	});
	/*
	 * Завершение редактирования имени
	 */
	$('#b_editname_block__cancel__').on('click', function() {
		$('.b_editname_block').hide();
		$('.b-editable[data-action="edit-name"]').show();
	});
	/*
	 * Результат редактирования имени стрельбы
	 */
	$('#b_editname_block__okey__').on('click', function(event) {
		var fireid = job;
		console.log(fireid);
		var text = $("#b_editname_block__firename__").val();
		console.log(text);
		$("#b_editname_block__okey__").hide();
		$("#b_editname_block__cancel__").hide();
		$("#b_editname_block__ajax__").show();

		$.ajax("/api/mobilejob/" + fireid + "/edit.json", {
			type : 'POST',
			contentType : 'application/json',
			dataType : 'json',
			data : JSON.stringify({
				name : text
			}),
			success : function(data) {
				if (data) {
					data = data[0];
					if (data.success === 1) {
						$('.b-editable[data-action="edit-name"]').text(text);
						$('.b_editname_block').hide();
						$('.b-editable[data-action="edit-name"]').show();
					}
				}
			},
		});
	});

	/*
	 * Редактирование описания
	 */
	$('.b-lunapark-offline-meta__description').on('click', function(event) {
		$('.b-editable[data-action="edit-dsc"]').hide();
		$('.b_editcomment_block').show();
		$("#b_editname_block__firecomment__").val($('.b-editable[data-action="edit-dsc"]').text());
		$("#b_editname_block__firecomment__").focus();

		$("#b_editcomment_block__okey__").show();
		$("#b_editcomment_block__cancel__").show();
		$("#b_editcomment_block__ajax__").hide();
	});

	$('#b_editcomment_block__cancel__').on('click', function(event) {
		$('.b_editcomment_block').hide();
		$('.b-editable[data-action="edit-dsc"]').show();
	});

	$('#b_editcomment_block__okey__').on('click', function(event) {
		var fireid = job;
		var text = $("#b_editname_block__firecomment__").val();

		$("#b_editcomment_block__okey__").hide();
		$("#b_editcomment_block__cancel__").hide();
		$("#b_editcomment_block__ajax__").show();

		$.ajax("/api/mobilejob/" + fireid + "/edit.json", {
			type : 'POST',
			contentType : 'application/json',
			dataType : 'json',
			data : JSON.stringify({
				description : text
			}),
			success : function(data) {
				if (data) {
					data = data[0];
					if (data.success === 1) {
						$('.b-editable[data-action="edit-dsc"]').text(text);
						$('.b_editcomment_block').hide();
						$('.b-editable[data-action="edit-dsc"]').show();
					}
				}
			},
		});
	});

	/*
	 * Редактирование разладки
	 */
	
	$('.b-lunapark-offline-meta__imbalance').on('click', function(event) {
		$('.b-editable[data-action="edit-imbalance"]').hide();
		$('.b_editimbalance_block').show();
		$("#b_editimbalance_block__firename__").val($('#b-lunapark-offline-meta__imbalance_value').text());
		$("#b_editimbalance_block__firename__").focus();

		$("#b_editimbalance_block__okey__").show();
		$("#b_editimbalance_block__cancel__").show();
		$("#b_editimbalance_block__ajax__").hide();
	});

	$('#b_editimbalance_block__cancel__').on('click', function(event) {
		$('.b_editimbalance_block').hide();
		$('.b-editable[data-action="edit-imbalance"]').show();
	});

	$('#b_editimbalance_block__okey__').on('click', function(event) {
		var fireid = job;
		var imbal = $("#b_editimbalance_block__firename__").val();

		$("#b_editimbalance_block__okey__").hide();
		$("#b_editimbalance_block__cancel__").hide();
		$("#b_editimbalance_block__ajax__").show();

		$.ajax("/api/job/" + fireid + "/edit.json", {
			type : 'POST',
			contentType : 'application/json',
			dataType : 'json',
			data : JSON.stringify({
				imbalance : imbal ? Math.round(imbal) : -1,
				person : $('#global-login').data('login')
			}),
			success : function(data) {
				if (data) {
					data = data[0];
					if (data.success === 1) {
						var imbal_html = '<b><span id="b-lunapark-offline-meta__imbalance_value">' + imbal + '</span> RPS</b> (' + $('#global-login').data('login') + ')';
						$('.b-editable[data-action="edit-imbalance"]').html('<span class="b-offlinepage-imbalance">' + ( imbal ? imbal_html : 'Не найдена') + "</span>");
						$('.b_editimbalance_block').hide();
						$('.b-editable[data-action="edit-imbalance"]').show();
					} else {
						reterror(data.error);
					}
				}
			},
		});
	});
})();
