/**
 * Created by noob on 19.01.17.
 */

( function() {

    'use strict';

    var component_id = $('#componentId').data('id');

/*
    $('.nav-link').on('click', function () {
        var url = '/mobileregress/' + $(this).data('project') + '/' + $(this).data('component');
        window.location = url
    });
*/

    $.getJSON('/mobileregress/'+component_id+'/plot.json', {}, function(data) {
        var cfg={
            chart: {
                reflow: false,
                height: 400,
                animation: false,
                style: {
                    fontFamily: 'Yandex Sans Text Web'
                },
                type: 'line'
            },
            series: data['series'],
            xAxis: {
                categories: data['categories']
            },
            yAxis: {
                opposite: false,
                title: {
                    text: null
                }
            },
            title: {
                text: "",
                style: {
                    fontFamily: '"Yandex Sans Text Web", "Lucida Grande", "Lucida Sans Unicode", Verdana, Arial, Helvetica, sans-serif;',
                }
            },
            tooltip : {
                animation : false,
                hideDelay: 10,
                shared: true
            },
            plotOptions: {
                series: {
                    animation: false,
                    shadow: false,
                    cursor: 'pointer',
                    states: {
                        hover: {
                            enabled: false
                        }
                    },
                    marker: {
                        symbol: 'circle',
                        radius: 2,
                        states: {
                            hover: {
                                enabled: true,
                                radiusPlus: 2
                            }
                        }
                    },
                    point: {
                        events: {
                            click: function() {
                                window.open('/mobile/'+this.category, '_blank');
                            }
                        }
                    }
                }
            },
            navigator: {
                enabled: false
            },
            rangeSelector: {
                enabled: false
            },
            scrollbar: {
                enabled: false
            },
            exporting: {
                enabled: false
            },
            credits: {
                enabled: false
            },
            legend : {
                enabled: true
            }
        };
        console.log(cfg);
        new Highcharts.Chart('mobileRegressChartContainer', cfg)
    });

    // Ресайзим график
    $( window ).resize(function() {
        var chart = Highcharts.charts[0];
        chart.setSize($('#mobileChartContainer').width(), 400, false)
    });

})();


