(function (){
	'use strict';
	var job_n = $('#global-job-number').data('job');

	$('.b-editable').bind('mouseenter', function() {
		$('span#'+this.id+'_pencil').show();
	});
	$('.b-editable').bind('mouseleave', function() {
		$('span#'+this.id+'_pencil').hide();
	});

	/*
	 * STOP BUTTON
	 */

	$('#online_stop').on('click', function(event) {
		$(this).hide();
		$('#online_stop__dialog').show()
	});

	$('#online_stop__cancel').on('click', function(event) {
		$('#online_stop__dialog').hide();
		$('#online_stop').show()
	});

	$('#online_stop__ok').on('click', function(event) {
		var job = $(this).data('job');
		$.ajax({
			url : '/api/jobclose_frontend?job_n=' + job,
			type : 'GET',
			async: false,
		}).success(function(){
			window.location = '/' + job
		})
	});

	/*
	 * При клике на редактирование имени стрельбы
	 */
	$('.b-overload-offline-meta__title.b-editable').on('click', function(event) {
		$('.b-editable[data-action="edit-name"]').hide();
		$('.b_editname_block').show();
		$("#b_editname_block__firename__").val($('.b-editable[data-action="edit-name"]').text());
		$("#b_editname_block__firename__").focus();

		$("#b_editname_block__okey__").show();
		$("#b_editname_block__cancel__").show();
		$("#b_editname_block__ajax__").hide();
	});
	/*
	 * Завершение редактирования имени
	 */
	$('#b_editname_block__cancel__').on('click', function(event) {
		$('.b_editname_block').hide();
		$('.b-editable[data-action="edit-name"]').show();
	});
	/*
	 * Результат редактирования стрельбы
	 */
	$('#b_editname_block__okey__').on('click', function(event) {
		var text = $("#b_editname_block__firename__").val();
		var block = this;

		$("#b_editname_block__okey__").hide();
		$("#b_editname_block__cancel__").hide();
		$("#b_editname_block__ajax__").show();

		$.ajax("/api/jobedit_frontend?job_n="+job_n, {
			type : 'POST',
			dataType : 'json',
			data : {
				'name' : text
			},
			success : function(data) {
				if (data) {
					if (data.success == 1) {
						$('.b-editable[data-action="edit-name"]').text(text);
						$('.b_editname_block').hide();
						$('.b-editable[data-action="edit-name"]').show();
					} else {
						reterror(data.error);
					}
				} else {
					reterror('error');
				}

			},
			error : function() {
				reterror('error');
			}
		});
		var reterror = function(typeoferror) {
			$("#b_editname_block__okey__").show();
			$("#b_editname_block__cancel__").show();
			$("#b_editname_block__ajax__").hide();
		};
	});


	/*
	 * Metainfo refresh (also checks if closed)
	 */

    	function activateMetainfoRefresh() {
	    	var job_finished = false;
	        var refreshMetainfoIntervalId = setInterval( function()
                {
                var url = '/online/refresh_meta_info.json?job=' + job_n;
                $.getJSON(url, function(data){

                    if (!data['online']) {
                        window.location = '/'+job_n+window.location.hash;
                        job_finished = true;
                    }

                    if (data['net_errors']==true) {
                        if ($('#netIndicator').hasClass('text-success')) {
                            $('#netIndicator').removeClass('text-success');
                            $('#netIndicator').addClass('text-danger')
                        }
                    }
                    else {
                        if ($('#netIndicator').hasClass('text-danger')) {
                            $('#netIndicator').removeClass('text-danger');
                            $('#netIndicator').addClass('text-success')
                        }
                    }
                    if (data['http_codes'][2]==true) {
                        if ( $('#http200Indicator').length == 0) {
                            $('#codesIndicators').append('<b class="label label-success b-overload-onlinepage__indicator" title="http" id="http200Indicator">2xx</b>')
                        }
                    }
                    if (data['http_codes'][3]==true) {
                        if ( $('#http300Indicator').length == 0) {
                            $('#codesIndicators').append('<b class="label label-info b-overload-onlinepage__indicator" title="http" id="http300Indicator">3xx</b>')
                        }
                    }
                    if (data['http_codes'][4]==true) {
                        if ( $('#http400Indicator').length == 0) {
                            $('#codesIndicators').append('<b class="label label-warning b-overload-onlinepage__indicator" title="http" id="http400Indicator">4xx</b>')
                        }
                    }
                    if (data['http_codes'][5]==true) {
                        if ( $('#http500Indicator').length == 0) {
                            $('#codesIndicators').append('<b class="label label-danger b-overload-onlinepage__indicator" title="http" id="http500Indicator">5xx</b>')
                        }
                    }
                });
                if (job_finished == true) {
                    window.clearInterval(refreshMetainfoIntervalId);
                }
            }, 1000 * parseInt($('.onlinepage__refresh.active').data('refresh')));
	}

	activateMetainfoRefresh();

	/*
	 * Редактирование описания
	 */
	$('.b-overload-offline-meta__description.b-editable').on('click', function(event) {
		$('.b-editable[data-action="edit-dsc"]').hide();
		$('.b_editdsc_block').show();
		$("#b_editdsc_block__dsc__").val($('.b-editable[data-action="edit-dsc"]').text());
		$("#b_editdsc_block__dsc__").focus();

		$("#b_editdsc_block__okey__").show();
		$("#b_editdsc_block__cancel__").show();
		$("#b_editdsc_block__ajax__").hide();
	});

	$('#b_editdsc_block__cancel__').on('click', function(event) {
		$('.b_editdsc_block').hide();
		$('.b-editable[data-action="edit-dsc"]').show();
	});

	$('#b_editdsc_block__okey__').on('click', function(event) {
		var text = $("#b_editdsc_block__dsc__").val();
		var block = this;

		$("#b_editdsc_block__okey__").hide();
		$("#b_editdsc_block__cancel__").hide();
		$("#b_editdsc_block__ajax__").show();
		$.ajax("/api/jobedit_frontend?job_n="+job_n, {
			type : 'POST',
			dataType : 'json',
			data : {
				'description' : text
			},
			success : function(data) {
				if (data) {
					if (data.success == 1) {
						$('.b-editable[data-action="edit-dsc"]').text(text);
						$('.b_editdsc_block').hide();
						$('.b-editable[data-action="edit-dsc"]').show();
					}
				} else {
					console.log('error')
				}
			},
			error : function() {
				console.log('error')
			}
		});
	});

})();
