/*
 * Объект работы проектом и списком тасков в проекте, а также списком стрельб в таске.
 */

(function() {

	function bindStars() {
		/*
		 * кнопка установки важности стрельбы
		 */
		var $starButton = $('a.job_star_on');
		$starButton.unbind('click');
		$starButton
				.click(
						function(event) {
							var job_star_toggle_url = '/projectpage/job_star_toggle/';
							var id = this.id.split('__')[1];
							$.get(job_star_toggle_url + id);

							$(this).hide();
							$('#job_star_off__' + id).show();
							event.preventDefault();
							event.stopPropagation();
						});

		/*
		 * кнопка снятия важности стрельбы
		 */
		var $unstarButton = $('a.job_star_off');
		$unstarButton.unbind('click');
		$unstarButton
				.click(
						function(event) {
							var job_star_toggle_url = '/projectpage/job_star_toggle/';
							var id = this.id.split('__')[1];
							$.get(job_star_toggle_url + id);

							$(this).hide();
							$('#job_star_on__' + id).show();
							event.preventDefault();
							event.stopPropagation();
						});
		
	}
	
	
	function bindPopupButtons() {
		
		/*
		 * кнопка для показа стрельб
		 */
		$('a.jobs_button')
			.click(
					function(event) {
						var popup_url = '/projectpage/jobs_popup/';
						var id = this.id.split('__')[1];
						$('#jobs_popup__' + id).toggle();
						$.get(popup_url + id, function(data) {
							$('#jobs_popup__' + id).html(data);
							bindStars();
						});

						var $icon = $(this).find('i');

						if ($icon.hasClass('text-danger')) {
							$icon.removeClass('fa-minus-square');
							$icon.removeClass('text-danger');
							$icon.addClass('fa-plus-square');
							$icon.addClass('text-success');
							$icon.attr('title', 'Показать задачи');
						} else {
							$icon.addClass('fa-minus-square');
							$icon.addClass('text-danger');
							$icon.removeClass('fa-plus-square');
							$icon.removeClass('text-success');
							$icon.attr('title', 'Скрыть задачи');
						}
						event.preventDefault();
						event.stopPropagation();
					});

		/*
		 * кнопка для скрытия стрельб
		 */
		$('a.jobs_hide_button').click(function(event) {
			var id = this.id.split('__')[1];
			$('#jobs_popup__' + id).hide();
			$('#jobs_show_button__' + id).show();
			$(this).hide();
		
			event.preventDefault();
			event.stopPropagation();
		});
	}
	
	bindPopupButtons();
	
    /*
	 * селекторы "Не закрытые"/"Все"
	 */

    var page = 0;
    var stopIteration = false;

    var $tableBody = $('#tasksTableBody');
    $tableBody.html('<tr id="krutilkaTd"><td><i style="margin-left:1em;" class="krutilka fa fa-circle-o-notch fa-spin"></i></td></tr>');
    
    $('.projectpage-tasks-selector').bind('click', 
		function(event) {
    		page = 0;
			var selector = this.id.split("__")[1];
			var project_code = $(this).data('project_code');
			$('.projectpage-tasks-selector.active').removeClass('active');
			$(this).addClass('active');
			var $tableBody = $('#tasksTableBody');
			$tableBody.html('<tr id="krutilkaTd"><td><i style="margin-left:1em;" class="krutilka fa fa-circle-o-notch fa-spin"></i></td></tr>');
			render_tasks();
			event.preventDefault();
    	});

    function render_tasks() {
        var project_name = $('#project_name').text();
        var selector = $('.projectpage-tasks-selector.active')[0].id.split('__')[1];
    	var $tableBody = $('#tasksTableBody');

    	var _taskTemplate = _.template($('#taskTemplate').text());

    	$.ajax({
            url: '/projectpage/tasks_block?page=' + page + '&project_code=' + project_name + '&select=' + selector,
            type: 'get',
            async: false,
            success: function (data) {
                var tasks = data['tasks'];
                var tl = tasks.length;
                if (tl > 0) {
                    $('#krutilkaTd').hide()
                }
                for (var i=0; i<tl; i++) {
                    var task = tasks[i];
                    $tableBody.append(_taskTemplate({task: task}));
                }
                page = data['page'];
                stopIteration = data['stop_iteration'];
                bindPopupButtons();

            },
        }, 'json');
	}

    $(document).ready(function() {
        render_tasks();
    });


	$(window).scroll(function() {
        if(!stopIteration && $(window).scrollTop() + window.innerHeight > ($(document).height()-1)) {
            render_tasks();
        }
    });

})();