# -*- coding: utf-8 -*-

from django.conf.urls import url, include

from .views.imbalance import Imbalance
from .views.jobaggregates import JobAggregates
from .views.jobclose import JobClose
from .views.jobconfiginfo import JobConfigInfo
from .views.jobconfiginitial import JobConfigInitial
from .views.jobconsole import JobConsole
from .views.jobcreate import JobCreate
from .views.jobdata import JobData
from .views.jobsla import JobSLA
from .views.jobdist import JobDist
from .views.jobloadscheme import JobLoadScheme
from .views.jobmetainfo import JobMetaInfo
from .views.jobmonitoring import JobMonitoring
from .views.jobmonitoringconfig import JobMonitoringConfigHandler
from .views.jobsoffline import JobsOffline
from .views.jobsqueued import JobsQueued
from .views.jobsonline import JobsOnline
from .views.jobsummary import JobSummary
from .views.jobtrailpush import JobTrailPush
from .views.regresscomponentlist import RegressComponentList
from .views.regressjoblist import RegressJobList
from .views.regresskpilist import RegressKPIList
from .views.server import ServerH
from .views.regressgetcomponent import RegressGetComponent
from .views.regressaddkpi import RegressAddKPI
from .views.regressmodkpi import RegressModKPI # Modify regression KPI
from .views.serverlock import ServerLock
from .views.tanks_map import get_tanks
from .views.tank import TankStatus
from .views.taskjoblist import TaskJobList
from .views.tasksummary import TaskSummary
from .views.memcacheclear import CacheClear
from .views.jobrepeat import JobRepeat
from .views.addartifact import AddArtifact
from .views.addammo import AddAmmo
from .views.addpandorabinary import AddPandoraBinary
from .views.jobregresscomment import RComment
from .views.jobevent import JobEventHandler
from .views.mobilejobmetainfo import MobileJobMetaInfo

from .views.auth_proxy import auth_proxy
from .views.check_upload_token import CheckUploadToken

from .views.customreportdelete import delete_custom_report
from .views.customreportadd import add_custom_report
from .views.hide_notification import hide_notification

from .views.jobclose import jobclose_frontend
from .views.jobmetainfo import jobedit_frontend
from .views.jobconfiginfo import job_configinfo
from .views.jobmonitoringconfig import job_monitoring_config
from .views.mobilejobmetainfo import jobedit_frontend as mobilejobedit_frontend
from .views.dummy import dummy

from api.views.v2.views import AmmoViewSet, ServerViewSet, TaskViewSet, ComponentViewSet, KpiViewSet, \
    RegressionCommentViewSet, JobViewSet, MobileJobViewSet
from rest_framework import routers

router = routers.DefaultRouter()
router.register(r'ammo', AmmoViewSet)
router.register(r'server', ServerViewSet, basename='server-host')
router.register(r'task', TaskViewSet, basename='task-key')
router.register(r'components', ComponentViewSet, basename='component-key')
router.register(r'kpis', KpiViewSet, basename='kpi-component-ktype')
router.register(r'regression_comments', RegressionCommentViewSet, basename='rcomments')
router.register(r'jobs', JobViewSet, basename='job-v2')
router.register(r'jobs/', JobViewSet, basename='job-v2-slash')
router.register(r'mobile_jobs', MobileJobViewSet, basename='mobilejob')


urlpatterns = [
    url(r'dummy', dummy),
    url(r'^v2/', include(router.urls)),
    url(r'^imbalance/(\d+)\.(json|xml)$', Imbalance.as_view()),
    url(r'^job/(\d+)/summary\.(json|xml|csv|csvs)$', JobSummary.as_view()),
    url(r'^job/(\d+)/aggregates\.(json|xml|csv|csvs)$', JobAggregates.as_view()),
    url(r'^job/(\d+)/loadscheme\.(json|xml|csv|csvs)$', JobLoadScheme.as_view()),
    url(r'^job/(\d+)/configinfo\.(txt)', JobConfigInfo.as_view()),
    url(r'^job/(\d+)/configinitial\.(txt)', JobConfigInitial.as_view()),
    url(r'^job/(\d+)/data/(times|http|net|cases|req_cases)\.(json|xml|csv|csvs)$', JobData.as_view()),
    url(r'^job/(\d+)/dist/(times|percentiles|http|net|cases)\.(json|xml|csv|csvs)$', JobDist.as_view()),
    url(r'^job/(\d+)/edit.(json)', JobMetaInfo.as_view()),
    url(r'^job/(\d+)/close.(json)', JobClose.as_view()),
    url(r'^job/(\d+)/sla.(json|xml|csv|csvs)', JobSLA.as_view()),
    url(r'^job/(\d+)/push_data.(json)$', JobTrailPush.as_view()),
    url(r'^job/(\d+)/console.(txt)', JobConsole.as_view()),
    url(r'^job/(\d+)/monitoring.(json|xml|csv|csvs)', JobMonitoring.as_view()),
    url(r'^job/(\d+)/jobmonitoringconfig.(txt)', JobMonitoringConfigHandler.as_view()),
    url(r'^job/(\d+)/repeat.(json)', JobRepeat.as_view()),
    url(r'^job/(\d+)/event.(json)', JobEventHandler.as_view()),
    url(r'^job/(\d+)/addartifact.(json)$', AddArtifact.as_view()),
    url(r'^job/(\d+)/regresscomment.(json)$', RComment.as_view()),
    url(r'^job/(\d+)/check_upload_token.(json)$', CheckUploadToken.as_view()),
    url(r'^job/create.(json)$', JobCreate.as_view()),
    url(r'^job/online.(json|xml|csv|csvs)$', JobsOnline.as_view()),
    url(r'^job/queued.(json|xml|csv|csvs)$', JobsQueued.as_view()),
    url(r'^job/offline.(json|xml|csv|csvs)$', JobsOffline.as_view()),
    url(r'^server/(virtual_host).(json)$', ServerH.as_view()),
    url(r'^server/(lock).(json)', ServerLock.as_view()),
    url(r'^server/(lock).(json)/', ServerLock.as_view()),
    url(r'^task/([A-Za-z]+-\d+)/summary.(json|xml|csv|csvs)$', TaskSummary.as_view()),
    url(r'^task/([A-Za-z]+-\d+)/joblist.(json|xml|csv|csvs)$', TaskJobList.as_view()),
    url(r'^regress/(\d+)/joblist.(json|xml|csv|csvs)$', RegressJobList.as_view()),
    url(r'^regress/([a-zA-Z]+)/componentlist.(json|xml|csv|csvs)$', RegressComponentList.as_view()),
    url(r'^regress/(\d+)/kpilist.(json|xml|csv|csvs)$', RegressKPIList.as_view()),
    url(r'^regress/component.(json)$', RegressGetComponent.as_view()),
    url(r'^regress/addkpi.(json)$', RegressAddKPI.as_view()),
    url(r'^regress/modkpi.(json)$', RegressModKPI.as_view()),
    url(r'^tank/status.(json|html)$', TankStatus.as_view()),
    url(r'^tanks_map.json$', get_tanks),
    url(r'^mobilejob/(\d+)/edit.(json)', MobileJobMetaInfo.as_view()),
    url(r'^memcacheclear.(json)$', CacheClear.as_view()),
    url(r'^cacheclear.(json)$', CacheClear.as_view()),
    url(r'^delete_custom_report', delete_custom_report),
    url(r'^add_custom_report', add_custom_report),
    url(r'^addammo.(json)$', AddAmmo.as_view()),
    url(r'^addpandorabinary.(json)$', AddPandoraBinary.as_view()),
    url(r'^auth_proxy', auth_proxy),
    url(r'^hide_notification.json', hide_notification),

    url(r'jobclose_frontend', jobclose_frontend),
    url(r'jobedit_frontend', jobedit_frontend),
    url(r'job_configinfo', job_configinfo),
    url(r'job_monitoring_config', job_monitoring_config),

    url(r'mobilejobedit_frontend', mobilejobedit_frontend),

]
