from .base import ApiJob
from common.models import JobImbalance
from django.http import Http404
import logging


class Imbalance(ApiJob):
    @staticmethod
    def get(request, job):
        """

        :param request: HTTP request
        :param job: job NUMBER
        """
        try:
            imb = JobImbalance.objects.filter(up=job).order_by('rob_isimbalance', '-hum_isimbalance', '-n')[0:1].get()
        except JobImbalance.DoesNotExist:
            raise Http404()
        if imb.hum_imbalance:
            return [{'imbalance': imb.hum_imbalance}]
        return [{'imbalance': imb.rob_imbalance}]
