from collections import OrderedDict

from common.models import JobTrail
from common.util.aggregators import RTDetailsAggregator, ProtoCodesAggregator, NetCodesAggregator, \
    RTHistogramsAggregator
from common.util.job_trail import set_job_trail
from .base import ApiJob


class JobAggregates(ApiJob):
    @staticmethod
    def get(request, job):
        """
        :param request: HTTP request
        :param job: job object passed from request
        """
        try:
            job_trail = JobTrail.objects.get(up=job.id)
        except JobTrail.DoesNotExist:
            set_job_trail(job)
            job_trail = JobTrail.objects.get(up=job.id)
        # TODO: tag array
        tag = request.GET.get('tag', '')
        start = request.GET.get('start')
        end = request.GET.get('end')

        result = [
            ('min_rps', job_trail.min_rps),
            ('max_rps', job_trail.max_rps),
            ('http', job_trail.http),
            ('net', job_trail.net),
            ('avg_resps', job_trail.avg_resps),
            ('trail_start', str(job_trail.trail_start)),
            ('trail_stop', str(job_trail.trail_stop)),
            ('avg_expect', job_trail.avg_expect),
            ('avg_connect_time', job_trail.avg_connect_time),
            ('avg_send_time', job_trail.avg_send_time),
            ('avg_latency', job_trail.avg_latency),
            ('avg_receive_time', job_trail.avg_receive_time),
            ('q50', int(job_trail.q50) if job_trail.q50 else 0),
            ('q75', int(job_trail.q75) if job_trail.q75 else 0),
            ('q80', int(job_trail.q80) if job_trail.q80 else 0),
            ('q85', int(job_trail.q85) if job_trail.q85 else 0),
            ('q90', int(job_trail.q90) if job_trail.q90 else 0),
            ('q95', int(job_trail.q95) if job_trail.q95 else 0),
            ('q98', int(job_trail.q98) if job_trail.q98 else 0),
            ('q99', int(job_trail.q99) if job_trail.q99 else 0)
        ]

        rt_detail_aggregator = RTDetailsAggregator(job, tag, start, end)
        rt_detail_aggregates = rt_detail_aggregator.aggregate()

        for aggr in rt_detail_aggregates.items():
            param = aggr[0]
            values = aggr[1]
            for key in list(values.keys()):
                result.append(('{}_{}'.format(str(param), key), values[key]))

        proto_codes_aggregator = ProtoCodesAggregator(job, tag, start, end)
        proto_codes_aggregates = proto_codes_aggregator.aggregate()

        for aggr in proto_codes_aggregates.items():
            param = aggr[0]
            values = aggr[1]
            for key in list(values.keys()):
                result.append(('http_{}_{}'.format(str(param), key), values[key]))

        net_codes_aggregator = NetCodesAggregator(job, tag, start, end)
        net_codes_aggregates = net_codes_aggregator.aggregate()

        for aggr in net_codes_aggregates.items():
            param = aggr[0]
            values = aggr[1]
            for key in list(values.keys()):
                result.append(('net_{}_{}'.format(str(param), key), values[key]))

        rt_histograms_aggregator = RTHistogramsAggregator(job, tag, start, end)
        rt_histograms_aggregates = rt_histograms_aggregator.aggregate()

        for aggr in rt_histograms_aggregates.items():
            param = aggr[0]
            values = aggr[1]
            for key in list(values.keys()):
                result.append(('time_{}_{}'.format(str(param), key), values[key]))

        result = [OrderedDict(result)]
        return result
