from django.http import Http404
from collections import OrderedDict
from .base import ApiJob
from common.models import LoadScheme


class JobLoadScheme(ApiJob):
    """
    retrieves loadscheme of a job
    """
    @staticmethod
    def get(request, job):
        """
        :param request: http request
        :param job: job object passed from request
        """
        if not job:
            raise Http404('Job not found')
        res = []
        for load_scheme in LoadScheme.objects.filter(up=job.n):
            res.append(OrderedDict([
                ('sec_from', load_scheme.sec_from),
                ('sec_to', load_scheme.sec_to),
                ('load_type', int(load_scheme.load_type)),
                ('load_from', int(load_scheme.load_from) if load_scheme.load_from % 1 == 0 else
                    load_scheme.load_from),
                ('load_to', int(load_scheme.load_to) if load_scheme.load_to % 1 == 0 else
                    load_scheme.load_to),
                ('dsc', load_scheme.dsc)
            ]))
        return res
