# -*- coding: utf-8 -*-
"""
Created on Aug 22, 2014

@author: noob
"""

from .base import ApiJob
import logging
from firestarter.views import _prepare_config, start
from json import dumps, loads


class JobRepeat(ApiJob):
    http_method_names = ['post']

    @staticmethod
    def post(request, job):
        try:
            params = loads(request.body)
            conf = _prepare_config(job, '')
            for key in list(params.keys()):
                try:
                    try:
                        conf[key.split(".")[0]]
                    except KeyError:
                        conf[key.split(".")[0]] = {}
                    conf[key.split(".")[0]][key.split(".")[1]] = params[key]
                except:
                    logging.exception("")
                    pass

            resp_post = request.POST.copy()
            resp_post.__setitem__('conf', dumps(conf))
            resp_post.__setitem__('api_handle', True)

            request.yauser = UserDummy(login=conf.get('meta', {}).get('operator', 'lunapark'))
            request.POST = resp_post
            res = start(request)
            res = loads(res.content)
            to_return = [res]
            if res.get('error', ''):
                to_return[0]['error'] = TRANSLATE.get(res['error'], res['error'])
            return to_return
        except Exception as exc:
            logging.exception('')
            return [{'success': False, 'error': str(exc)}]


class UserDummy(object):
    def __init__(self, login='lunapark'):
        self.login = login

    @staticmethod
    def is_authenticated():
        return True


TRANSLATE = {
    'Мишень не находится ни в одном из доступных датацентров': 'Wrong DC',
    "К сожалению, подходящих свободных танков сейчас нет.": 'All tanks are busy',
    "Нет такого файла с патронами": "Ammo not found",
    "Нет связи с големом": "Golem is unavailable",
    "Не указан адрес мишени в секции phantom или bfg": "address is not specified in phantom section or bfg section",
    "Неверный формат схемы нагрузки": "Invalid loadscheme",
    "Не указана схема нагрузки": "loadscheme is not specified in phantom section or bfg section",
    "Неверный формат автостопа": "Incorrect autostop",
}
