"""
Created on Feb 6, 2014

@author: noob
"""
from .base import ApiJob
from regression.views.sla_processor import JobSLAProcessor
import logging


class JobSLA(ApiJob):
    """
    job results distributions
    """

    @staticmethod
    def get(_, job):
        """

        :param _: Http request
        :param job:
        :return:
        """
        try:
            job_sla_processor = JobSLAProcessor(job)
            sla_resolution = job_sla_processor.check()
            result = {'success': 1}
            result.update(sla_resolution)
            return [result]
        except Exception as exc:
            logging.exception("Could not check sla for job {} due to:".format(job.n))
            return [{'success': 0, 'error': exc.__class__.__name__}]
