# -*- coding: utf-8 -*-
"""
Created on Feb 14, 2014

@author: noob
"""
from .base import Api
from common.util.clients import CacheClient
from json import loads
import logging


class CacheClear(Api):
    @staticmethod
    def post(request):
        cache = CacheClient()
        request_data = loads(request.body)
        cache_key = request_data.get('key')
        try:
            assert cache_key, 'No "key" specified'
            data = cache.get(cache_key)
            assert data, 'No data in memcache for key: {}'.format(cache_key)
            cache.delete(cache_key)
            return [{'success': 1}]
        except AssertionError as aexc:
            logging.error(aexc)
            return [{'success': 0, 'error': aexc}]
        except Exception as exc:
            logging.exception('Could not clear memcache for key: {} due to:'.format(cache_key))
            return [{'success': 0, 'error': exc.__class__.__name__}]
