import logging

from django.db import connection
from django.http.response import HttpResponse, HttpResponseServerError

from common.util.clients import ClickhouseClient


def ping(request):
    try:
        cursor = connection.cursor()
        try:
            cursor.execute('select 1')
        except Exception as exc:
            raise exc
        finally:
            cursor.close()
        ch_client = ClickhouseClient()
        ch_client.select(b'select 1')
        return HttpResponse('pong')
    except Exception:
        logging.exception('Ping failed', exc_info=True)
        return HttpResponseServerError('Ping failed, check db connection')
