from .base import Api
from common.util.clients import CacheClient
from django.http import HttpResponse


class TankStatus(Api):
    http_method_names = ['get']

    def get(self, request):

        fmt = request.path_info.split('.')[-1]
        cache = CacheClient()
        data = cache.get('tanks_status_{}'.format(fmt))
        if fmt == 'html':
            return HttpResponse(data, content_type='text/html; charset=UTF-8')
        else:
            return data
