# -*- coding: utf-8 -*-
from .base import ApiTask
from common.util.clients import StartrekClient
import logging


class TaskSummary(ApiTask):
    """
    returns rendered task info
    """

    @staticmethod
    def get(_, task):
        """
        :param _: HTTP request
        :param task: task key from request
        """
        res = []
        try:
            st_task = StartrekClient().get_task(task)
            res = [{
                'task': st_task.key,
                # FIXME: надо, чтобы танку было пофиг на то, открыт таск или нет.
                'status': "Open",  # task.status.key.capitalize(),
                'opened': st_task.createdAt,
                'closed': st_task.updatedAt if st_task.status.key == 'closed' else None,
                'name': st_task.summary,
                'reporter': st_task.createdBy.login,
                'assignee': st_task.assignee.login if st_task.assignee else '',
                'version': st_task.version
            }]
        except Exception:
            logging.exception('Failed to get startrek task', exc_info=True)
            res = [{
                'task': task,
                'status': "Open",
                'opened': '',
                'closed': None,
                'name': '',
                'reporter': 'lunapark',
                'assignee': 'lunapark',
                'version': ''
            }]  # костылик для старых танков
        return res
