#!/usr/bin/env python
# -*- coding: utf-8 -*-

from common.models import KPI
from django.core.management.base import BaseCommand
import json


class Command(BaseCommand):

    def handle(self, *args, **options):
        for kpi in KPI.objects.all():
            if isinstance(kpi.params, dict):
                kp = {}
                for k, v in kpi.params.items():
                    if k == 'target':
                        kp[k] = v.n
                    elif k == 'metric':
                        kp[k] = v.id
                    else:
                        kp[k] = v
                kpi.params_json = json.dumps(kp)
                kpi.save()
