from django.core.management.base import BaseCommand
from common.util.clients import CacheClient


class Command(BaseCommand):
    help = ''

    @staticmethod
    def add_arguments(parser):
        parser.add_argument(
            '--action',
            default='',
            help='set or unset',
        )

    def handle(self, *args, **options):
        action = options['action']

        cache = CacheClient()
        if action == 'set':
            cache.set(key='maintenance', value=True)
        elif action == 'unset':
            cache.set(key='maintenance', value=False)
