from django.core.management.base import BaseCommand
from common.util.clients import CacheClient
from common.util.meta import parse_duration
import time


class Command(BaseCommand):
    help = ''

    @staticmethod
    def add_arguments(parser):
        parser.add_argument(
            '--text',
            default='',
            help='Enter notification text',
        )

        parser.add_argument(
            '--exp',
            default='1d',
            help='Expiration period for notification (defaults to 1d)',
        )

    def handle(self, *args, **options):
        text = options['text']
        expire = options['exp']

        now = time.time()
        expire = now + parse_duration(str(expire))

        CacheClient().set(
            key='notification',
            value={
                'text': text,
                'expire': int(expire),
                'author': 'admin_shell',
            }
        )